% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netEmbedding}
\alias{netEmbedding}
\title{Manifold learning of the signaling networks based on their similarity}
\usage{
netEmbedding(
  object,
  slot.name = "netP",
  type = c("functional", "structural"),
  comparison = NULL,
  pathway.remove = NULL,
  umap.method = c("umap-learn", "uwot"),
  n_neighbors = NULL,
  min_dist = 0.3,
  ...
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{type}{"functional","structural"}

\item{comparison}{a numerical vector giving the datasets for comparison. No need to define for a single dataset. Default are all datasets when object is a merged object}

\item{pathway.remove}{a range of the number of patterns}

\item{umap.method}{UMAP implementation to run.

Can be umap-learn: Run the python umap-learn package; uwot: Runs umap via the uwot R package;  If umap.method = "uwot", please make sure you have installed the 'uwot' (https://github.com/jlmelville/uwot)}

\item{n_neighbors}{the number of nearest neighbors in running umap}

\item{min_dist}{This controls how tightly the embedding is allowed compress points together.
Larger values ensure embedded points are moreevenly distributed, while smaller values allow the
algorithm to optimise more accurately with regard to local structure. Sensible values are in the range 0.001 to 0.5.}

\item{...}{Parameters passing to umap}
}
\description{
Manifold learning of the signaling networks based on their similarity
}
