% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_signalingRole_network}
\alias{netAnalysis_signalingRole_network}
\title{Heatmap showing the centrality scores/importance of cell groups as senders, receivers, mediators and influencers in a single intercellular communication network}
\usage{
netAnalysis_signalingRole_network(
  object,
  signaling,
  slot.name = "netP",
  measure = c("outdeg", "indeg", "flowbet", "info"),
  measure.name = c("Sender", "Receiver", "Mediator", "Influencer"),
  color.use = NULL,
  color.heatmap = "BuGn",
  width = 6.5,
  height = 1.4,
  font.size = 8,
  font.size.title = 10,
  cluster.rows = FALSE,
  cluster.cols = FALSE
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a character vector giving the name of signaling networks}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{measure}{centrality measures to show}

\item{measure.name}{the names of centrality measures to show}

\item{color.use}{the character vector defining the color of each cell group}

\item{color.heatmap}{a color name in brewer.pal}

\item{width}{width of heatmap}

\item{height}{height of heatmap}

\item{font.size}{fontsize in heatmap}

\item{font.size.title}{font size of the title}

\item{cluster.rows}{whether cluster rows}

\item{cluster.cols}{whether cluster columns}
}
\description{
Heatmap showing the centrality scores/importance of cell groups as senders, receivers, mediators and influencers in a single intercellular communication network
}
