% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_diff_signalingRole_scatter}
\alias{netAnalysis_diff_signalingRole_scatter}
\title{2D visualization of differential signaling roles (dominant senders (sources) or receivers (targets) ) of each cell group when comparing mutiple datasets}
\usage{
netAnalysis_diff_signalingRole_scatter(
  object,
  color.use = NULL,
  comparison = c(1, 2),
  signaling = NULL,
  signaling.exclude = NULL,
  idents.exclude = NULL,
  slot.name = "netP",
  group = NULL,
  dot.size = 2.5,
  point.shape = c(21, 22, 24, 23, 25, 8, 3),
  label.size = 3,
  dot.alpha = 0.6,
  x.measure = "outdeg",
  y.measure = "indeg",
  xlabel = "Outgoing interaction strength",
  ylabel = "Incoming interaction strength",
  title = NULL,
  font.size = 10,
  font.size.title = 10,
  do.label = T,
  show.legend = T,
  show.axes = T
)
}
\arguments{
\item{object}{A merged CellChat object of a list of CellChat objects}

\item{color.use}{defining the color for each cell group}

\item{comparison}{an index vector giving the two datasets for comparison}

\item{signaling}{a char vector containing signaling pathway names. signaling = NULL: Signaling role analysis on the aggregated cell-cell communication network from all signaling pathways}

\item{signaling.exclude}{signaling pathways to exclude}

\item{idents.exclude}{cell groups to exclude. This is useful when zooming into the small changes}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{group}{a vector to categorize the cell groups, e.g., categorize the cell groups into two major categories: immune cells and fibroblasts}

\item{dot.size}{the size of the symbol}

\item{point.shape}{point shape when group is not NULL}

\item{label.size}{font size of the text}

\item{dot.alpha}{transparency}

\item{x.measure}{The measure used as x-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "outdeg" is the weighted outgoing links (i.e., Outgoing interaction strength). If setting as "outdeg_unweighted", it represents the total number of outgoing signaling.}

\item{y.measure}{The measure used as y-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "indeg" is the weighted incoming links (i.e., Incoming interaction strength). If setting as "indeg_unweighted", it represents the total number of incoming signaling.}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{title}{main title of the plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}

\item{do.label}{label the each point}

\item{show.legend}{whether show the legend}

\item{show.axes}{whether show the axes}
}
\value{
ggplot object
}
\description{
This scatter plot shows the differential signaling roles (dominant senders (sources) or receivers (targets) in a 2D space.

x-axis and y-axis are respectively the differential outgoing or incoming communication probability associated with each cell group.
Dot colors indicate different cell groups. Dot shapes indicate different categories of cell groups if `group`` is defined.

Positive values indicate the increase in the second dataset while negative values indicate the increase in the first dataset
}
