% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_contribution}
\alias{netAnalysis_contribution}
\title{Compute and visualize the contribution of each ligand-receptor pair in the overall signaling pathways}
\usage{
netAnalysis_contribution(
  object,
  signaling,
  signaling.name = NULL,
  sources.use = NULL,
  targets.use = NULL,
  width = 0.1,
  vertex.receiver = NULL,
  thresh = 0.05,
  return.data = FALSE,
  x.rotation = 0,
  title = "Contribution of each L-R pair",
  font.size = 10,
  font.size.title = 10
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a signaling pathway name}

\item{signaling.name}{alternative signaling pathway name to show on the plot}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{width}{the width of individual bar}

\item{vertex.receiver}{a numeric vector giving the index of the cell groups as targets in the first hierarchy plot}

\item{thresh}{threshold of the p-value for determining significant interaction}

\item{return.data}{whether return the data.frame consisting of the predicted L-R pairs and their contribution}

\item{x.rotation}{rotation of x-label}

\item{title}{the title of the plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}
}
\description{
Compute and visualize the contribution of each ligand-receptor pair in the overall signaling pathways
}
