% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{identifyCommunicationPatterns}
\alias{identifyCommunicationPatterns}
\title{Identification of major signals for specific cell groups and general communication patterns}
\usage{
identifyCommunicationPatterns(
  object,
  slot.name = "netP",
  pattern = c("outgoing", "incoming"),
  k = NULL,
  k.range = seq(2, 10),
  heatmap.show = TRUE,
  color.use = NULL,
  color.heatmap = "Spectral",
  title.legend = "Contributions",
  width = 4,
  height = 6,
  font.size = 8
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{pattern}{"outgoing" or "incoming"}

\item{k}{the number of patterns}

\item{k.range}{a range of the number of patterns}

\item{heatmap.show}{whether showing heatmap}

\item{color.use}{the character vector defining the color of each cell group}

\item{color.heatmap}{a color name in brewer.pal}

\item{title.legend}{the title of legend in heatmap}

\item{width}{width of heatmap}

\item{height}{height of heatmap}

\item{font.size}{fontsize in heatmap}
}
\description{
Identification of major signals for specific cell groups and general communication patterns
}
