% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{findEnrichedSignaling}
\alias{findEnrichedSignaling}
\title{Find the enriched signaling according to the genes (e.g.DEGs) and cell groups of interest}
\usage{
findEnrichedSignaling(
  object,
  features,
  idents = NULL,
  pattern = c("both", "outgoing", "incoming"),
  thresh = 0.05
)
}
\arguments{
\item{object}{CellChat object}

\item{features}{a vector giving the genes of interest}

\item{idents}{a vector giving the names of cell groups of interest. If idents = NULL, it returns signaling according to the input features.}

\item{pattern}{"both", "outgoing" or "incoming"}

\item{thresh}{threshold of the p-value for determining significant interaction}
}
\value{
a dataframe of the cell-cell communication associated with the input features.
}
\description{
Find the enriched signaling according to the genes (e.g.DEGs) and cell groups of interest
}
\examples{
\dontrun{
# find all the significant outgoing signaling according to the features and cell groups of interest
df <- findEnrichedSignaling(object, features = c("CCL19", "CXCL12"), idents = c("Inflam. FIB", "COL11A1+ FIB"), pattern ="outgoing")
}
}
