% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{filterCommunication}
\alias{filterCommunication}
\title{Filter cell-cell communication if there are only few number of cells in certain cell groups or inconsistent cell-cell communication across samples}
\usage{
filterCommunication(
  object,
  min.cells = 10,
  min.samples = NULL,
  rare.keep = FALSE,
  nonFilter.keep = FALSE
)
}
\arguments{
\item{object}{CellChat object}

\item{min.cells}{The minmum number of cells required in each cell group for cell-cell communication}

\item{min.samples}{The minmum number of samples required for consistent cell-cell communication across samples (that is an interaction present in at least `min.samples` samples) when mutiple samples/replicates/batches are merged as an input for CellChat analysis.}

\item{rare.keep}{Whether to keep the interactions associated with the rare populations when min.samples >= 2. When a rare population is identified in the merged samples (say 15 cells in this rare population from two samples), it is likely to filter out the interactions associated with this rare population when setting min.samples >= 2. Setting `rare.keep = TRUE` to retain the identified interactions associated with this rare population.}

\item{nonFilter.keep}{Whether to keep the non-filtered cell-cell communication in the CellChat object. This is useful for avoiding re-running `computeCommunProb` if you want to adjust the parameters when running `filterCommunication`.}
}
\value{
CellChat object with an updated slot net
}
\description{
Filter cell-cell communication if there are only few number of cells in certain cell groups or inconsistent cell-cell communication across samples
}
