% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{extractEnrichedLR_internal}
\alias{extractEnrichedLR_internal}
\title{Identify all the significant interactions (L-R pairs) and related signaling genes for a given signaling pathway}
\usage{
extractEnrichedLR_internal(
  net,
  LR,
  DB,
  signaling,
  enriched.only = TRUE,
  thresh = 0.05
)
}
\arguments{
\item{net, LR, DB}{object@net object@LR object@DB}

\item{signaling}{a char vector containing signaling pathway names for searching}

\item{enriched.only}{whether only return the identified enriched signaling genes in the database. Default = TRUE, returning the significantly enriched signaling interactions}

\item{thresh}{threshold of the p-value for determining significant interaction}
}
\value{
a list: list(geneLR, pairLR.name.use)
}
\description{
Identify all the significant interactions (L-R pairs) and related signaling genes for a given signaling pathway
}
