% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{extractEnrichedLR}
\alias{extractEnrichedLR}
\title{Identify all the significant interactions (L-R pairs) and related signaling genes for a given signaling pathway}
\usage{
extractEnrichedLR(
  object,
  signaling,
  geneLR.return = FALSE,
  enriched.only = TRUE,
  thresh = 0.05,
  geneInfo = NULL,
  complex_input = NULL
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a char vector containing signaling pathway names for searching}

\item{geneLR.return}{whether return the related signaling genes of enriched L-R pairs}

\item{enriched.only}{whether only return the identified enriched signaling genes in the database. Default = TRUE, returning the significantly enriched signaling interactions}

\item{thresh}{threshold of the p-value for determining significant interaction}

\item{geneInfo}{a dataframe with gene official symbol (there should be one column named `Symbol`)}

\item{complex_input}{signaling complex information from CellChatDB}
}
\value{
The returned value depends on the input argument:

When `geneLR.return = FALSE`, it returns a data frame containing the significant interactions (L-R pairs)

When `geneLR.return = TRUE`, it returns a list, the first element is a data frame containing the significant interactions (L-R pairs), and the second is a vector containing the related signaling genes of enriched L-R pairs, which can be used for examining the gene expression pattern using the function \code{\link{plotGeneExpression}}
}
\description{
Identify all the significant interactions (L-R pairs) and related signaling genes for a given signaling pathway
}
