% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{dotPlot}
\alias{dotPlot}
\title{Dot plot}
\usage{
dotPlot(
  object,
  features,
  rotation = TRUE,
  colormap = "OrRd",
  color.direction = 1,
  color.use = c("#F8766D", "#00BFC4"),
  scale = TRUE,
  col.min = -2.5,
  col.max = 2.5,
  dot.scale = 6,
  assay = "RNA",
  idents = NULL,
  group.by = NULL,
  split.by = NULL,
  legend.width = 0.5,
  angle.x = 45,
  hjust.x = 1,
  angle.y = 0,
  hjust.y = 0.5,
  show.legend = TRUE,
  ...
)
}
\arguments{
\item{object}{seurat object}

\item{features}{Features to plot (gene expression, metrics)}

\item{rotation}{whether rotate the plot}

\item{colormap}{RColorbrewer palette to use (check available palette using RColorBrewer::display.brewer.all()). default will use customed color palette}

\item{color.direction}{Sets the order of colours in the scale. If 1, the default, colours are as output by RColorBrewer::brewer.pal(). If -1, the order of colours is reversed.}

\item{color.use}{defining the color for each condition/dataset}

\item{scale}{whther show x-axis text}

\item{col.min}{Minimum scaled average expression threshold (everything smaller will be set to this)}

\item{col.max}{Maximum scaled average expression threshold (everything larger will be set to this)}

\item{dot.scale}{Scale the size of the points, similar to cex}

\item{assay}{Name of assay to use, defaults to the active assay}

\item{idents}{Which classes to include in the plot (default is all)}

\item{group.by}{Name of one or more metadata columns to group (color) cells by
(for example, orig.ident); pass 'ident' to group by identity class}

\item{split.by}{Name of a metadata column to split plot by;}

\item{legend.width}{legend width}

\item{angle.x}{angle for x-axis text rotation}

\item{hjust.x}{adjust x axis text}

\item{angle.y}{angle for y-axis text rotation}

\item{hjust.y}{adjust y axis text}

\item{show.legend}{whether show the legend}

\item{...}{Extra parameters passed to DotPlot from Seurat package}
}
\value{
ggplot2 object
}
\description{
The size of the dot encodes the percentage of cells within a class, while the color encodes the AverageExpression level across all cells within a class
}
