% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{computeEnrichmentScore}
\alias{computeEnrichmentScore}
\title{Compute and visualize the enrichment score of ligand-receptor pairs in one condition compared to another condition}
\usage{
computeEnrichmentScore(
  df,
  measure = c("ligand", "signaling", "LR-pair"),
  variable.both = TRUE,
  species = c("mouse", "human"),
  db = NULL,
  color.use = NULL,
  color.name = "Dark2",
  n.color = 8,
  scale = c(4, 0.8),
  min.freq = 0,
  max.words = 200,
  random.order = FALSE,
  rot.per = 0,
  return.data = FALSE,
  seed = 1,
  ...
)
}
\arguments{
\item{df}{a dataframe}

\item{measure}{compute the enrichment score in terms of "ligand", "signaling",or "LR-pair"}

\item{variable.both}{variable.both = TRUE will require that both ligand and receptor from one pair are over-expressed;
variable.both = FALSE will only require that either ligand or receptor from one pair is over-expressed.}

\item{species}{define the species as one of the c('mouse','human') to extract the CellChatDB; For other species, users need to provide a ligand-receptor database `db`}

\item{db}{a customized ligand-receptor database `db`}

\item{color.use}{defining the color for each group of datasets}

\item{color.name}{the color names in RColorBrewer::brewer.pal}

\item{n.color}{the number of colors}

\item{scale}{A vector of length 2 indicating the range of the size of the words.}

\item{min.freq}{words with frequency below min.freq will not be plotted}

\item{max.words}{Maximum number of words to be plotted. least frequent terms dropped}

\item{random.order}{plot words in random order. If false, they will be plotted in decreasing frequency}

\item{rot.per}{proportion words with 90 degree rotation}

\item{return.data}{whether return the data frame for plotting wordcloud}

\item{seed}{set a seed}

\item{...}{Other parameters passing to wordcloud::wordcloud}
}
\value{
A ggplot object
}
\description{
Compute and visualize the enrichment score of ligand-receptor pairs in one condition compared to another condition
}
