% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{computeAveExpr}
\alias{computeAveExpr}
\title{Compute averaged expression values for each cell group}
\usage{
computeAveExpr(
  object,
  features = NULL,
  group.by = NULL,
  type = c("triMean", "truncatedMean", "median"),
  trim = NULL,
  slot.name = c("data.signaling", "data"),
  data.use = NULL
)
}
\arguments{
\item{object}{CellChat object}

\item{features}{a char vector giving the used features. default use all features}

\item{group.by}{cell group information; default is `object@idents` when input is a single object and `object@idents$joint` when input is a merged object; otherwise it should be one of the column names of the meta slot}

\item{type}{methods for computing the average gene expression per cell group.

By default = "triMean", defined as a weighted average of the distribution's median and its two quartiles (https://en.wikipedia.org/wiki/Trimean);

When setting `type = "truncatedMean"`, a value should be assigned to 'trim'. See the function `base::mean`.}

\item{trim}{the fraction (0 to 0.25) of observations to be trimmed from each end of x before the mean is computed.}

\item{slot.name}{the data in the slot.name to use}

\item{data.use}{a customed data matrix. Default: data.use = NULL and the expression matrix in the 'slot.name' is used}
}
\value{
Returns a matrix with genes as rows, cell groups as columns.
}
\description{
Compute averaged expression values for each cell group
}
