% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{compareInteractions}
\alias{compareInteractions}
\title{Comparing the number of inferred communication links between different datasets}
\usage{
compareInteractions(
  object,
  measure = c("count", "weight"),
  color.use = NULL,
  group = NULL,
  group.levels = NULL,
  group.facet = NULL,
  group.facet.levels = NULL,
  n.row = 1,
  color.alpha = 1,
  legend.title = NULL,
  width = 0.6,
  title.name = NULL,
  digits = 3,
  xlabel = NULL,
  ylabel = NULL,
  remove.xtick = FALSE,
  show.legend = TRUE,
  x.lab.rot = FALSE,
  angle.x = 45,
  vjust.x = NULL,
  hjust.x = 1,
  size.text = 10
)
}
\arguments{
\item{object}{A merged CellChat object}

\item{measure}{"count" or "weight". "count": comparing the number of interactions; "weight": comparing the total interaction weights (strength)}

\item{color.use}{defining the color for each group of datasets}

\item{group}{a vector giving the groups of different datasets to define colors of the bar plot. Default: only one group and a single color}

\item{group.levels}{the factor level in the defined group}

\item{group.facet}{Name of one metadata column defining faceting groups}

\item{group.facet.levels}{the factor level in the defined group.facet}

\item{n.row}{Number of rows in facet_grid()}

\item{color.alpha}{transparency}

\item{legend.title}{legend title}

\item{width}{bar width}

\item{title.name}{main title of the plot}

\item{digits}{integer indicating the number of decimal places (round) to be used when `measure` is `weight`.}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{remove.xtick}{whether remove xtick}

\item{show.legend}{whether show the legend}

\item{x.lab.rot, angle.x, vjust.x, hjust.x}{adjusting parameters if rotating xtick.labels when x.lab.rot = TRUE}

\item{size.text}{font size of the text}
}
\value{
A ggplot object
}
\description{
Comparing the number of inferred communication links between different datasets
}
