% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{addReduction}
\alias{addReduction}
\title{Add a reduced space of the data into CellChat object}
\usage{
addReduction(
  object,
  dr = NULL,
  dr.name = NULL,
  seu.obj = NULL,
  dr.use = NULL,
  force.add = FALSE
)
}
\arguments{
\item{object}{CellChat object from a single dataset}

\item{dr}{A data frame (rows are cells with rownames) consisting of a low-dimensional space for visualization}

\item{dr.name}{A char name of the reduction method for the input `dr`}

\item{seu.obj}{A Seurat object with the reduced space of the data}

\item{dr.use}{A char name of the reduction method to use when taking `seu.obj` as input. By default, all reduced space in `seu.obj` will be added in `object@dr`}

\item{force.add}{Whether to force to add a new reduced space when a reduced space exists in `object@dr`}
}
\description{
Add a reduced space of the data into CellChat object
}
\examples{
\dontrun{
cellChat <- addReduction(object = cellchat, dr = cell.embeddings, dr.name = "umap")

cellChat <- addReduction(object = cellchat, seu.obj = seu.obj)
}
}
