#include "RE/F/FormTypes.h"

#include "RE/F/FORM_ENUM_STRING.h"

namespace RE
{
	std::string_view FormTypeToString(FormType a_formType) noexcept
	{
		switch (a_formType) {
		case FormType::PluginInfo:
			return "TES4";
		case FormType::FormGroup:
			return "GRUP";
		case FormType::GameSetting:
			return "GMST";
		case FormType::Keyword:
			return "KYWD";
		case FormType::LocationRefType:
			return "LCRT";
		case FormType::Action:
			return "AACT";
		case FormType::TextureSet:
			return "TXST";
		case FormType::MenuIcon:
			return "MICN";
		case FormType::Global:
			return "GLOB";
		case FormType::Class:
			return "CLAS";
		case FormType::Faction:
			return "FACT";
		case FormType::HeadPart:
			return "HDPT";
		case FormType::Eyes:
			return "EYES";
		case FormType::Race:
			return "RACE";
		case FormType::Sound:
			return "SOUN";
		case FormType::AcousticSpace:
			return "ASPC";
		case FormType::Skill:
			return "SKIL";
		case FormType::MagicEffect:
			return "MGEF";
		case FormType::Script:
			return "SCPT";
		case FormType::LandTexture:
			return "LTEX";
		case FormType::Enchantment:
			return "ENCH";
		case FormType::Spell:
			return "SPEL";
		case FormType::Scroll:
			return "SCRL";
		case FormType::Activator:
			return "ACTI";
		case FormType::TalkingActivator:
			return "TACT";
		case FormType::Armor:
			return "ARMO";
		case FormType::Book:
			return "BOOK";
		case FormType::Container:
			return "CONT";
		case FormType::Door:
			return "DOOR";
		case FormType::Ingredient:
			return "INGR";
		case FormType::Light:
			return "LIGH";
		case FormType::Misc:
			return "MISC";
		case FormType::Apparatus:
			return "APPA";
		case FormType::Static:
			return "STAT";
		case FormType::StaticCollection:
			return "SCOL";
		case FormType::MovableStatic:
			return "MSTT";
		case FormType::Grass:
			return "GRAS";
		case FormType::Tree:
			return "TREE";
		case FormType::Flora:
			return "FLOR";
		case FormType::Furniture:
			return "FURN";
		case FormType::Weapon:
			return "WEAP";
		case FormType::Ammo:
			return "AMMO";
		case FormType::NPC:
			return "NPC_";
		case FormType::LeveledNPC:
			return "LVLN";
		case FormType::KeyMaster:
			return "KEYM";
		case FormType::AlchemyItem:
			return "ALCH";
		case FormType::IdleMarker:
			return "IDLM";
		case FormType::Note:
			return "NOTE";
		case FormType::ConstructibleObject:
			return "COBJ";
		case FormType::Projectile:
			return "PROJ";
		case FormType::Hazard:
			return "HAZD";
		case FormType::SoulGem:
			return "SLGM";
		case FormType::LeveledItem:
			return "LVLI";
		case FormType::Weather:
			return "WTHR";
		case FormType::Climate:
			return "CLMT";
		case FormType::ShaderParticleGeometryData:
			return "SPGD";
		case FormType::ReferenceEffect:
			return "RFCT";
		case FormType::Region:
			return "REGN";
		case FormType::Navigation:
			return "NAVI";
		case FormType::Cell:
			return "CELL";
		case FormType::Reference:
			return "REFR";
		case FormType::ActorCharacter:
			return "ACHR";
		case FormType::ProjectileMissile:
			return "PMIS";
		case FormType::ProjectileArrow:
			return "PARW";
		case FormType::ProjectileGrenade:
			return "PGRE";
		case FormType::ProjectileBeam:
			return "PBEA";
		case FormType::ProjectileFlame:
			return "PFLA";
		case FormType::ProjectileCone:
			return "PCON";
		case FormType::ProjectileBarrier:
			return "PBAR";
		case FormType::PlacedHazard:
			return "PHZD";
		case FormType::WorldSpace:
			return "WRLD";
		case FormType::Land:
			return "LAND";
		case FormType::NavMesh:
			return "NAVM";
		case FormType::TLOD:
			return "TLOD";
		case FormType::Dialogue:
			return "DIAL";
		case FormType::Info:
			return "INFO";
		case FormType::Quest:
			return "QUST";
		case FormType::Idle:
			return "IDLE";
		case FormType::Package:
			return "PACK";
		case FormType::CombatStyle:
			return "CSTY";
		case FormType::LoadScreen:
			return "LSCR";
		case FormType::LeveledSpell:
			return "LVSP";
		case FormType::AnimatedObject:
			return "ANIO";
		case FormType::Water:
			return "WATR";
		case FormType::EffectShader:
			return "EFSH";
		case FormType::TOFT:
			return "TOFT";
		case FormType::Explosion:
			return "EXPL";
		case FormType::Debris:
			return "DEBR";
		case FormType::ImageSpace:
			return "IMGS";
		case FormType::ImageAdapter:
			return "IMAD";
		case FormType::FormList:
			return "FLST";
		case FormType::Perk:
			return "PERK";
		case FormType::BodyPartData:
			return "BPTD";
		case FormType::AddonNode:
			return "ADDN";
		case FormType::ActorValueInfo:
			return "AVIF";
		case FormType::CameraShot:
			return "CAMS";
		case FormType::CameraPath:
			return "CPTH";
		case FormType::VoiceType:
			return "VTYP";
		case FormType::MaterialType:
			return "MATT";
		case FormType::Impact:
			return "IPCT";
		case FormType::ImpactDataSet:
			return "IPDS";
		case FormType::Armature:
			return "ARMA";
		case FormType::EncounterZone:
			return "ECZN";
		case FormType::Location:
			return "LCTN";
		case FormType::Message:
			return "MESG";
		case FormType::Ragdoll:
			return "RGDL";
		case FormType::DefaultObject:
			return "DOBJ";
		case FormType::LightingMaster:
			return "LGTM";
		case FormType::MusicType:
			return "MUSC";
		case FormType::Footstep:
			return "FSTP";
		case FormType::FootstepSet:
			return "FSTS";
		case FormType::StoryManagerBranchNode:
			return "SMBN";
		case FormType::StoryManagerQuestNode:
			return "SMQN";
		case FormType::StoryManagerEventNode:
			return "SMEN";
		case FormType::DialogueBranch:
			return "DLBR";
		case FormType::MusicTrack:
			return "MUST";
		case FormType::DialogueView:
			return "DLVW";
		case FormType::WordOfPower:
			return "WOOP";
		case FormType::Shout:
			return "SHOU";
		case FormType::EquipSlot:
			return "EQUP";
		case FormType::Relationship:
			return "RELA";
		case FormType::Scene:
			return "SCEN";
		case FormType::AssociationType:
			return "ASTP";
		case FormType::Outfit:
			return "OTFT";
		case FormType::ArtObject:
			return "ARTO";
		case FormType::MaterialObject:
			return "MATO";
		case FormType::MovementType:
			return "MOVT";
		case FormType::SoundRecord:
			return "SNDR";
		case FormType::DualCastData:
			return "DUAL";
		case FormType::SoundCategory:
			return "SNCT";
		case FormType::SoundOutputModel:
			return "SOPM";
		case FormType::CollisionLayer:
			return "COLL";
		case FormType::ColorForm:
			return "CLFM";
		case FormType::ReverbParam:
			return "REVB";
		case FormType::LensFlare:
			return "LENS";
		case FormType::LensSprite:
			return "LSPR";
		case FormType::VolumetricLighting:
			return "VOLI";
		default:
			return "NONE";
		}
	}

	FormType StringToFormType(std::string_view a_formType)
	{
		for (auto& iter : FORM_ENUM_STRING::GetFormEnumString()) {
			if (_stricmp(iter.formString, a_formType.data()) == 0) {
				return iter.formType;
			}
		}

		return FormType::None;
	}
}
