// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * DOMContentLoaded handler, sets up the page.
 */
function load() {

  // Decorate the existing elements in the document.
  cr.ui.decorate('input[pref][type=checkbox]',
    options.PrefCheckbox);
  cr.ui.decorate('input[pref][type=number]',
    options.PrefNumber);
  cr.ui.decorate('input[pref][type=radio]',
    options.PrefRadio);
  cr.ui.decorate('input[pref][type=range]',
    options.PrefRange);
  cr.ui.decorate('select[pref]',
    options.PrefSelect);
  cr.ui.decorate('input[pref][type=text]',
    options.PrefTextField);
  cr.ui.decorate('input[pref][type=url]',
    options.PrefTextField);
  cr.ui.decorate('button[pref]',
    options.PrefButton);
  cr.ui.decorate('#content-settings-page input[type=radio]:not(.handler-radio)',
    options.ContentSettingsRadio);
  cr.ui.decorate('#content-settings-page input[type=radio].handler-radio',
    options.HandlersEnabledRadio);
  cr.ui.decorate('span.controlled-setting-indicator',
    options.ControlledSettingIndicator);

  var menuOffPattern = /(^\?|&)menu=off($|&)/;
  var menuDisabled = menuOffPattern.test(window.location.search);
  // document.documentElement.setAttribute('hide-menu', menuDisabled);
  // We can't use an attribute on the html element because of webkit bug
  // 12519. Instead, we add a class.
  if (menuDisabled)
    document.documentElement.classList.add('hide-menu');
}

document.addEventListener('DOMContentLoaded', load);
