@icon("res://addons/escoria-core/design/esc_exit.svg")
## An ESCExit is a minimal feature node that provides an exit to a room.[br]
## [br]
## For exits that don't require scripts, the ``ESCExit`` node is provided.
## The only things you will need to configure on the node are the
## "target_scene" to change to, and optionally, a "switch
## sound" (the sound to play when changing rooms).[br]
## [br]
## If you want to attach the exit to a script to perform additional actions -
## a cutscene for example - use an ``ESCItem`` with "Is Exit" selected instead.[br]
## [br]
## The game character will automatically walk to an ``ESCLocation`` created as a
## child of an ``ESCExit`` node.
extends ESCItem
class_name ESCExit


## Path to the target scene to change to
@export_file("*.tscn", "*.scn") var target_scene: String = ""

## Sound effect to play when changing the scene
@export var switch_sound: Resource # (String, FILE, "*.ogg,*.mp3,*.wav")

## String value to be used as UI hint, for example to determine the mouse cursor to use.
@export var exit_direction = ""

## ESC PlaySnd command kept around for reference
var _play_snd: PlaySndCommand

## ESC ChangeScene command kept around for reference
var _change_scene: ChangeSceneCommand


## Called on entering scene tree. Force is_exit to true.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns nothing.
func _enter_tree():
	is_exit = true


## Called when node is ready.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns nothing.
func _ready():
	super._ready()
	_play_snd = PlaySndCommand.new()
	_change_scene = ChangeSceneCommand.new()

	call_deferred("_register_event")


## Registers the exit_scene event based on the properties[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns nothing.
func _register_event():
	if escoria.object_manager.has(self.global_id) and\
			not escoria.event_manager.EVENT_EXIT_SCENE in escoria.object_manager.get_object(
				self.global_id
			).events:

		var exit_scene_script_builder: ESCScriptBuilder = ESCScriptBuilder.new()

		exit_scene_script_builder.add_event(escoria.event_manager.EVENT_EXIT_SCENE, [])
		exit_scene_script_builder.begin_block()

		if switch_sound != null:
			exit_scene_script_builder.add_command(
				_play_snd.get_command_name(),
				switch_sound.resource_path
			)

		exit_scene_script_builder.add_command(
			_change_scene.get_command_name(),
			target_scene
		)

		var exit_scene_event = \
			escoria.esc_compiler.compile(exit_scene_script_builder.build(), get_class()) \
				.events[escoria.event_manager.EVENT_EXIT_SCENE]

		escoria.object_manager.get_object(self.global_id) \
			.events[escoria.event_manager.EVENT_EXIT_SCENE] = exit_scene_event
