## Represents a token generated by the ASHES scanner to be parsed by the ASHES
## parser.
##
## This class contains any information required by the parser but also carries
## with it associated information useful for debugging and tracing purposes.
extends RefCounted
class_name ESCToken


var _tokenType: int: # ESCScanner.TokenType enum
	get = get_type
var _lexeme: String:
	get = get_lexeme
var _literal:
	get = get_literal
var _line: int:
	get = get_line
var _source: String:
	get = get_source,
	set = set_source
var _filename: String:
	get = get_filename


## Initialization method. Must be called after instantiation.[br]
## [br]
## #### Parameters[br]
## [br]
## | Name | Type | Description | Required? |[br]
## |:-----|:-----|:------------|:----------|[br]
## |tokenType|`int`|a value from `ESCTokenType.TokenType`|yes|[br]
## |lexeme|`String`|text corresponding to the scanned token|yes|[br]
## |literal|`Variant`|if the token represents a literal value, this is that value; can be null|yes|[br]
## |source|`String`|the source code (script) containing the token, if available|yes|[br]
## |line|`int`|the line in the source containing the token, if available|yes|[br]
## |filename|`String`|the path of the file containing the token, if available|yes|[br]
## [br]
## #### Returns[br]
## [br]
## Returns nothing.
func init(tokenType: int, lexeme: String, literal, source: String, line: int, filename: String) -> void:
	_tokenType = tokenType
	_lexeme = lexeme
	_literal = literal
	_source = source
	_line = line
	_filename = filename


## Sets the source of the token. This is typically the entire script file as a string.[br]
## [br]
## #### Parameters[br]
## [br]
## | Name | Type | Description | Required? |[br]
## |:-----|:-----|:------------|:----------|[br]
## |value|`String`|Full script source used to resolve this token.|yes|[br]
## [br]
## #### Returns[br]
## [br]
## Returns nothing.
func set_source(value: String) -> void:
	_source = value


## The source of the token.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the source of the token. (`String`)
func get_source() -> String:
	return _source


## The type of token this is; will be a value from `ESCTokenType.TokenType`.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the type of token this is; will be a value from `ESCTokenType.TokenType`. (`int`)
func get_type() -> int:
	return _tokenType


## The literal value of the token, if it exists.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the literal value of the token, if it exists. (`Variant`)
func get_literal():
	return _literal


## The lexeme of the token; this is typically the text corresponding to the token.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the lexeme of the token; this is typically the text corresponding to the token. (`String`)
func get_lexeme() -> String:
	return _lexeme


## The line number of the token.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the line number of the token. (`int`)
func get_line() -> int:
	return _line


## The path of the file containing the token.[br]
## [br]
## #### Parameters[br]
## [br]
## None.
## [br]
## #### Returns[br]
## [br]
## Returns the path of the file containing the token. (`String`)
func get_filename() -> String:
	return _filename


func _to_string() -> String:
	return ESCTokenType.get_token_type_name(_tokenType) + " " + str(_lexeme) + " " + (str(_literal) if _literal else "")
