# Jumpserver random seed leakage and account takeover (CVE-2023-42820)

[中文版本(Chinese version)](README.zh-cn.md)

Jumpserver is a Popular Open Source PAM (Privileged Access Management) system that provides web-based SSH (Secure Shell) and RDP (Remote Desktop Protocol) gateway.

In the version prior to 3.6.4 is affected by a high severity vulnerability. This vulnerability is due to a third-party library [django-simple-captcha](https://github.com/mbi/django-simple-captcha) exposing the random number seed to the API, potentially allowing the randomly generated verification codes to be replayed, which could lead to password resets.

References:

- <https://github.com/jumpserver/jumpserver/security/advisories/GHSA-7prv-g565-82qp>
- <https://mp.weixin.qq.com/s/VShjaDI1McerX843YyOENw>
<!-- - <https://www.leavesongs.com/PENETRATION/jumpserver-sep-2023-multiple-vulnerabilities-go-through.html> -->

## Vulnerable environment

Before starting the server, change the value of `DOMAINS` in [config.env](config.env) to your IP and port, e.g. `DOMAINS=your-ip:8080`.

Execute following command to start a Jumpserver v3.6.3:

```
docker compose up -d
```

After waiting for a while, open `http://your-ip:8080` to see the Jumpserver login page.

## Vulnerability reproduce

I wrote a fairly straightforward semi-automated script to reproduce this vulnerability. Since it's semi-automated, it's crucial to follow the steps below meticulously to reproduce it accurately.

Firstly, open the 'Forgot Password' page in the tab #1 of your browser: `http://your-ip:8080/core/auth/password/forget/previewing/`. At this point, there will be a captcha displayed on the page.

- If the captcha includes the number "10", refresh it, as our script currently can't handle it
- If the captcha doesn't include the number "10", proceed to open this captcha in a new tab (tab #2)

The captcha image's URL must contain a SHA1 hash like `http://your-ip:8080/core/auth/captcha/image/87b2723d404657c2294abfab908975ebb9da5468/`, copy the hash as **seed** and we will use it later.

Return to the tab #1 and refresh the page. The purpose of refreshing is to **not use** the captcha containing the **seed** as this seed will be utilized in the subsequent steps.

After refreshing the page, correctly fill in the username and new captcha and submit it. You will be redirected to the captcha verification page.

The URL of this page should like `http://localhost:8080/core/auth/password/forgot/?token=sceOx7yWuAH9wWcuzc0nMQmLBzEPNhkhuTfl`, containing a random token value. Record this value as the **token**.

Use our [POC](poc.py):

```
python poc.py -t http://localhost:8080 --email admin@mycomany.com --seed [seed] --token [token]
```

This script requires 4 parameters:

- `-t` The target Jumpserver server URL
- `--email` The email address of the user to takeover (In vulhub is `admin@mycomany.com`)
- `--seed` The pseudorandom number **seed** noted earlier
- `--token` The **token** noted earlier

Upon the execution of the script, the predicted code value will be displayed:

![](1.png)

Return to your browser, enter this code and submit it. You will then be directed to the new password modification page; change the password accordingly.

For the complete reproduction process, please refer to the following [this gif](https://i.imgur.com/JXanh2I.gif):

![](https://i.imgur.com/JXanh2I.gif)
