# Django 500 Debug Page Cross-Site Scripting (XSS) (CVE-2017-12794)

[中文版本(Chinese version)](README.zh-cn.md)

Django is a high-level Python web framework that encourages rapid development and clean, pragmatic design.

Django versions before 1.11.5 and 1.10.8 contain a cross-site scripting (XSS) vulnerability in the debug error page. When DEBUG mode is enabled, error pages could potentially expose sensitive information through unescaped HTML in the error message.

The vulnerability is triggered when a database error occurs and its details are displayed in the debug page. The error message from the database is not properly escaped before being rendered in the template.

References:

- <https://www.djangoproject.com/weblog/2017/sep/05/security-releases/>
- <https://nvd.nist.gov/vuln/detail/CVE-2017-12794>
- <https://www.leavesongs.com/PENETRATION/django-debug-page-xss.html>

## Environment Setup

Execute the following command to start a vulnerable Django server (the version of Django is 1.11.4):

```
docker compose up -d
```

After the server is started, you can access the Django home page at `http://your-ip:8000`.

## Vulnerability Reproduction

Visit the following URL to create a user with a malicious username containing JavaScript code:

```
http://your-ip:8000/create_user/?username=<script>alert(1)</script>
```

The first request will succeed. Then, visit the same URL again to trigger a database unique constraint error. The error page will include the unescaped username in the error message:

![](1.png)

The JavaScript code in the username will be executed in the browser, demonstrating the XSS vulnerability. This vulnerability could be exploited by attackers to execute arbitrary JavaScript code in the context of the debug page, potentially leading to session hijacking or other client-side attacks.

For detailed principle of this vulnerability, please refer to the third link in the references section: <https://www.leavesongs.com/PENETRATION/django-debug-page-xss.html>
