/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.ffm.mapping;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import org.lwjgl.system.ffm.mapping.IntegerMappings;
import org.lwjgl.system.ffm.mapping.Mapping;
import org.lwjgl.system.ffm.mapping.PrimitiveMappings;

public interface Mapping<L extends MemoryLayout> {
    public L layout();

    public Mapping<L> typedef(String var1);

    public Mapping<L> cconst();

    default public Pointer p() {
        return new Pointer(this.layout());
    }

    public static Opaque createOpaque(String name) {
        return new Opaque(name);
    }

    public static Boolean createBoolean(String name) {
        return PrimitiveMappings.create((ValueLayout.OfBoolean)ValueLayout.JAVA_BOOLEAN.withName(name));
    }

    public static Byte createByte(String name, boolean signed) {
        return IntegerMappings.create((ValueLayout.OfByte)ValueLayout.JAVA_BYTE.withName(name), (boolean)signed);
    }

    public static Char createChar(String name) {
        return IntegerMappings.create((ValueLayout.OfChar)ValueLayout.JAVA_CHAR.withName(name));
    }

    public static Short createShort(String name, boolean signed) {
        return IntegerMappings.create((ValueLayout.OfShort)ValueLayout.JAVA_SHORT.withName(name), (boolean)signed);
    }

    public static Int createInt(String name, boolean signed) {
        return IntegerMappings.create((ValueLayout.OfInt)ValueLayout.JAVA_INT.withName(name), (boolean)signed);
    }

    public static Long createLong(String name, boolean signed) {
        return IntegerMappings.create((ValueLayout.OfLong)ValueLayout.JAVA_LONG.withName(name), (boolean)signed);
    }

    public static CLong createCLong(String name, boolean signed) {
        return IntegerMappings.createCLong((String)name, (boolean)signed);
    }

    public static Size createSize(String name, boolean signed) {
        return IntegerMappings.create((AddressLayout)ValueLayout.ADDRESS.withName(name), (boolean)signed);
    }

    public static Float createFloat(String name) {
        return PrimitiveMappings.create((ValueLayout.OfFloat)ValueLayout.JAVA_FLOAT.withName(name));
    }

    public static Double createDouble(String name) {
        return PrimitiveMappings.create((ValueLayout.OfDouble)ValueLayout.JAVA_DOUBLE.withName(name));
    }
}

