/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.ffm;

import java.io.IOException;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.TypeKind;
import java.lang.classfile.attribute.ModuleAttribute;
import java.lang.classfile.attribute.ModuleExportInfo;
import java.lang.classfile.attribute.ModuleRequireInfo;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.constant.ModuleDesc;
import java.lang.constant.PackageDesc;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.ffm.BCCallDown;
import org.lwjgl.system.ffm.BCCallUp;
import org.lwjgl.system.ffm.BCDescriptors;
import org.lwjgl.system.ffm.BCUtil;
import org.lwjgl.system.ffm.Binder;
import org.lwjgl.system.ffm.FFM;
import org.lwjgl.system.ffm.FFMConfig;
import org.lwjgl.system.ffm.GroupBinder;
import org.lwjgl.system.ffm.UpcallBinder;
import org.lwjgl.system.ffm.mapping.Mapping;
import org.lwjgl.system.libffi.FFICIF;

/*
 * Exception performing whole class analysis ignored.
 */
public final class FFM {
    static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    static final Set<String> STANDARD_CHARSETS = Arrays.stream(StandardCharsets.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toUnmodifiableSet());
    static final ConcurrentHashMap<AnnotatedElement, FFMConfig> BINDING_CONFIGS = new ConcurrentHashMap();
    static final ScopedValue<Arena> ARENA = ScopedValue.newInstance();
    public static final Mapping.Opaque opaque = Mapping.createOpaque((String)"void");
    public static final Mapping.Boolean jboolean = Mapping.createBoolean((String)"boolean");
    public static final Mapping.Byte jbyte = Mapping.createByte((String)"byte", (boolean)true);
    public static final Mapping.Char jchar = Mapping.createChar((String)"char");
    public static final Mapping.Short jshort = Mapping.createShort((String)"short", (boolean)true);
    public static final Mapping.Int jint = Mapping.createInt((String)"int", (boolean)true);
    public static final Mapping.Long jlong = Mapping.createLong((String)"long", (boolean)true);
    public static final Mapping.Float jfloat = Mapping.createFloat((String)"float");
    public static final Mapping.Double jdouble = Mapping.createDouble((String)"double");
    public static final Mapping.Byte int8_t = jbyte.typedef("int8_t");
    public static final Mapping.Short int16_t = jshort.typedef("int16_t");
    public static final Mapping.Int int32_t = jint.typedef("int32_t");
    public static final Mapping.Long int64_t = jlong.typedef("int64_t");
    public static final Mapping.Byte uint8_t = Mapping.createByte((String)"uint8_t", (boolean)false);
    public static final Mapping.Short uint16_t = Mapping.createShort((String)"uint16_t", (boolean)false);
    public static final Mapping.Int uint32_t = Mapping.createInt((String)"uint32_t", (boolean)false);
    public static final Mapping.Long uint64_t = Mapping.createLong((String)"uint64_t", (boolean)false);
    public static final Mapping.Size size_t = Mapping.createSize((String)"size_t", (boolean)false);
    public static final Mapping.Size ptrdiff_t = Mapping.createSize((String)"ptrdiff_t", (boolean)true);
    public static final Mapping.Size intptr_t = Mapping.createSize((String)"intptr_t", (boolean)true);
    public static final Mapping.Size uintptr_t = Mapping.createSize((String)"uintptr_t", (boolean)false);
    public static final Mapping.Boolean bool = jboolean.typedef("bool");
    public static final Mapping.Byte cchar = int8_t.typedef("char");
    public static final Mapping.Short cshort = int16_t.typedef("short");
    public static final Mapping.Int cint = int32_t.typedef("int");
    public static final Mapping.CLong clong = Mapping.createCLong((String)"long", (boolean)true);
    public static final Mapping.Long long_long = jlong.typedef("long long");
    public static final Mapping.Byte unsigned_char = uint8_t.typedef("unsigned char");
    public static final Mapping.Short unsigned_short = uint16_t.typedef("unsigned short");
    public static final Mapping.Int unsigned_int = uint32_t.typedef("unsigned int");
    public static final Mapping.CLong unsigned_long = Mapping.createCLong((String)"unsigned long", (boolean)false);
    public static final Mapping.Long unsigned_long_long = uint64_t.typedef("unsigned long long");
    public static final Mapping.Float float32 = jfloat.typedef("float");
    public static final Mapping.Double float64 = jdouble.typedef("double");

    private FFM() {
    }

    static void main() {
        Path path = Path.of("bin", "classes", "lwjgl", "core", "META-INF", "versions", "25", "module-info.class");
        ModuleAttribute moduleAttr = ModuleAttribute.of((ModuleDesc)ModuleDesc.of("org.lwjgl"), mab -> {
            mab.moduleVersion(System.getProperty("module.version")).requires(ModuleRequireInfo.of((ModuleDesc)ModuleDesc.of("java.base"), (int)AccessFlag.MODULE.mask(), (String)"25")).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.ffm"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.freebsd"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.jni"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.libc"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.libffi"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.linux"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.macosx"), (int)0, (ModuleDesc[])new ModuleDesc[0])).exports(ModuleExportInfo.of((PackageDesc)PackageDesc.of("org.lwjgl.system.windows"), (int)0, (ModuleDesc[])new ModuleDesc[0]));
            if (Boolean.getBoolean("unsafe")) {
                mab.requires(ModuleRequireInfo.of((ModuleDesc)ModuleDesc.of("jdk.unsupported"), (int)AccessFlag.TRANSITIVE.mask(), (String)"25"));
            }
        });
        try {
            ClassFile.of().buildModuleTo(path, moduleAttr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static FFMConfig getConfig(Class<?> bindingInterface) {
        for (Class<?> c = bindingInterface; c != null; c = c.getEnclosingClass()) {
            FFMConfig config = (FFMConfig)BINDING_CONFIGS.get(c);
            if (config == null) continue;
            return config;
        }
        Package p = Objects.requireNonNull(bindingInterface.getPackage());
        FFMConfig config = (FFMConfig)BINDING_CONFIGS.get(p);
        if (config == null) {
            throw new IllegalStateException("No FFMConfig registered for " + String.valueOf(bindingInterface));
        }
        return config;
    }

    private static <T> T generate(Class<T> bindingInterface, FFMConfig config) throws Exception {
        Method[] methods = bindingInterface.getMethods();
        ClassDesc thisClass = ClassDesc.of(bindingInterface.getPackageName(), bindingInterface.getSimpleName() + "Impl");
        byte[] bytecode = ClassFile.of().build(thisClass, classBuilder -> {
            BCUtil.startHiddenClass((ClassBuilder)classBuilder).withInterfaceSymbols(new ClassDesc[]{bindingInterface.describeConstable().orElseThrow()});
            for (int m = 0; m < methods.length; ++m) {
                Method method = methods[m];
                MethodTypeDesc methodTypeDesc = BCUtil.getMethodTypeDesc((Method)method);
                DynamicConstantDesc condy = DynamicConstantDesc.ofNamed(BCDescriptors.DMHD_FFM_bootstrapDowncall, method.getName(), ConstantDescs.CD_MethodHandle, Integer.valueOf(m));
                classBuilder.withMethod(method.getName(), methodTypeDesc, 1, mb -> mb.withCode(cb -> {
                    cb.ldc((ConstantDesc)condy);
                    for (int p = 0; p < methodTypeDesc.parameterCount(); ++p) {
                        cb.loadLocal(TypeKind.from((TypeDescriptor.OfField)methodTypeDesc.parameterType(p)), cb.parameterSlot(p));
                    }
                    cb.invokevirtual(ConstantDescs.CD_MethodHandle, "invokeExact", methodTypeDesc).return_(TypeKind.from((TypeDescriptor.OfField)methodTypeDesc.returnType()));
                }));
            }
        });
        return (T)config.lookup.defineHiddenClassWithClassData(bytecode, List.of(config, methods), false, new MethodHandles.Lookup.ClassOption[0]).lookupClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static MethodHandle bootstrapDowncall(MethodHandles.Lookup lookup, String name, Class<?> bootstrapClass, int methodIndex) throws IllegalAccessException {
        FFMConfig config = MethodHandles.classDataAt(lookup, "_", FFMConfig.class, 0);
        Method method = MethodHandles.classDataAt(lookup, "_", Method[].class, 1)[methodIndex];
        if (config.debugGenerator) {
            APIUtil.apiLog("BOOTSTRAPPING DOWNCALL#" + methodIndex + ": " + name);
        }
        return new BCCallDown(config, method).bootstrap();
    }

    static Field findBinderField(Class<?> targetType) {
        Field field = null;
        for (Field targetField : targetType.getDeclaredFields()) {
            Class binderClass;
            ParameterizedType binderTypeGeneric;
            Type[] binderTypeArguments;
            int modifiers = targetField.getModifiers();
            if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers))) {
                throw new IllegalStateException(String.valueOf(targetType) + " is not an interface");
            }
            Type binderType = targetField.getGenericType();
            if (!(binderType instanceof ParameterizedType) || (binderTypeArguments = (binderTypeGeneric = (ParameterizedType)binderType).getActualTypeArguments()).length != 1 || !binderTypeArguments[0].equals(targetType) || !GroupBinder.class.isAssignableFrom(binderClass = (Class)binderTypeGeneric.getRawType()) && !UpcallBinder.class.isAssignableFrom(binderClass)) continue;
            if (field != null) {
                throw new IllegalStateException("Multiple binder fields found for " + String.valueOf(targetType));
            }
            field = targetField;
        }
        if (field == null) {
            throw new IllegalStateException("No binder field found for " + String.valueOf(targetType));
        }
        return field;
    }

    static FFMConfig.BinderField lookupBinder(FFMConfig config, Class<?> targetType) {
        FFMConfig.BinderField binderField = (FFMConfig.BinderField)config.binders.get(targetType);
        if (binderField == null) {
            binderField = FFM.lookupBinderCacheMiss((FFMConfig)config, targetType);
        }
        return binderField;
    }

    private static FFMConfig.BinderField lookupBinderCacheMiss(FFMConfig config, Class<?> targetType) {
        Binder binder;
        Field field = FFM.findBinderField(targetType);
        try {
            binder = (Binder)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (binder == null) {
            throw new IllegalStateException("Missing binder field value for " + String.valueOf(targetType));
        }
        FFMConfig.BinderField binderField = new FFMConfig.BinderField(field.getName(), binder);
        config.binders.put(targetType, binderField);
        return binderField;
    }

    public static <T> StructBinderBuilder<T> ffmStruct(Class<T> structInterface) {
        return new StructBinderBuilder(structInterface);
    }

    public static <T> UnionBinderBuilder<T> ffmUnion(Class<T> unionInterface) {
        return new UnionBinderBuilder(unionInterface);
    }

    public static <T> UpcallBinder<T> ffmUpcall(Class<T> upcallInterface) {
        return FFM.ffmUpcall(upcallInterface, null);
    }

    public static <T> UpcallBinder<T> ffmUpcall(Class<T> upcallInterface, @Nullable FFICIF cif) {
        FFMConfig config = FFM.getConfig(upcallInterface);
        if (config.debugGenerator) {
            APIUtil.apiLog("BOOTSTRAPPING UPCALL " + String.valueOf(upcallInterface));
        }
        return new BCCallUp(config, upcallInterface, cif).bootstrap();
    }

    public static ScopedValue<Arena> ffmScopedArena() {
        return ARENA;
    }

    public static void ffmScopedRun(Arena arena, Runnable runnable) {
        ScopedValue.where(ARENA, arena).run(runnable);
    }

    public static <R, X extends Throwable> R ffmScopedCall(Arena arena, ScopedValue.CallableOp<? extends R, X> op) throws X {
        return (R)ScopedValue.where(ARENA, arena).call(op);
    }

    public static <T> T ffmGenerate(Class<T> bindingInterface) {
        try {
            return (T)FFM.generate(bindingInterface, (FFMConfig)FFM.getConfig(bindingInterface));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T ffmGenerate(Class<T> bindingInterface, FFMConfig config) {
        FFMConfig previous = BINDING_CONFIGS.put(bindingInterface, config);
        try {
            Object object = FFM.generate(bindingInterface, (FFMConfig)config);
            return (T)object;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            FFM.ffmConfig(bindingInterface, (FFMConfig)previous);
        }
    }

    public static FFMConfigBuilder ffmConfigBuilder(MethodHandles.Lookup lookup) {
        return new FFMConfigBuilder(lookup);
    }

    public static void ffmConfig(Package _package, @Nullable FFMConfig config) {
        if (config == null) {
            BINDING_CONFIGS.remove(_package);
        } else {
            BINDING_CONFIGS.put(_package, config);
        }
    }

    public static void ffmConfig(Class<?> _class, @Nullable FFMConfig config) {
        if (config == null) {
            BINDING_CONFIGS.remove(_class);
        } else {
            BINDING_CONFIGS.put(_class, config);
        }
    }
}

