/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import java.util.Objects;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.SegmentStack;
import org.lwjgl.system.ffm.StackAllocator;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentStack
implements StackAllocator<SegmentStack>,
AutoCloseable {
    private static final long DEFAULT_STACK_SIZE = (long)Configuration.STACK_SIZE.get(64).intValue() * 1024L;
    private static final int DEFAULT_STACK_FRAMES = 8;
    private static final ThreadLocal<SegmentStack> TLS = ThreadLocal.withInitial(SegmentStack::create);
    private final MemorySegment container;
    private final long size;
    private long pointer;
    private long[] frames;
    protected int frameIndex;

    protected SegmentStack(MemorySegment container) {
        this.container = container;
        this.size = container.byteSize();
        this.pointer = container.byteSize();
        this.frames = new long[8];
    }

    public static SegmentStack create() {
        return SegmentStack.create((long)DEFAULT_STACK_SIZE);
    }

    public static SegmentStack create(long capacity) {
        return SegmentStack.create((MemorySegment)Arena.ofAuto().allocate(capacity));
    }

    public static SegmentStack create(MemorySegment segment) {
        return Configuration.DEBUG_STACK.get(false) != false ? new DebugMemoryStack(segment) : new SegmentStack(segment);
    }

    public SegmentStack push() {
        if (this.frameIndex == this.frames.length) {
            this.frameOverflow();
        }
        this.frames[this.frameIndex++] = this.pointer;
        return this;
    }

    private void frameOverflow() {
        if (Checks.DEBUG) {
            APIUtil.apiLog("[WARNING] Out of frame stack space (" + this.frames.length + ") in thread: " + String.valueOf(Thread.currentThread()));
        }
        this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
    }

    public SegmentStack pop() {
        this.pointer = this.frames[--this.frameIndex];
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public long getAddress() {
        return this.container.address();
    }

    public long getSize() {
        return this.container.byteSize();
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public long getPointerAddress() {
        return this.container.address() + this.pointer;
    }

    public long getPointer() {
        return this.pointer;
    }

    public void setPointer(long pointer) {
        if (Checks.CHECKS) {
            this.checkPointer(pointer);
        }
        this.pointer = pointer;
    }

    private void checkPointer(long pointer) {
        if (pointer < 0L || this.size < pointer) {
            throw new IndexOutOfBoundsException("Invalid stack pointer");
        }
    }

    private static void checkAlignment(long alignment) {
        if (Long.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power-of-two value.");
        }
    }

    public MemorySegment allocate(long byteSize) {
        return this.allocate(byteSize, ValueLayout.ADDRESS.byteAlignment());
    }

    public MemorySegment allocate(long byteSize, long byteAlignment) {
        if (Checks.DEBUG) {
            SegmentStack.checkAlignment((long)byteAlignment);
        }
        long address = this.container.address() + this.pointer - byteSize & -byteAlignment;
        this.pointer = address - this.container.address();
        if (Checks.CHECKS && this.pointer < 0L) {
            throw new OutOfMemoryError("Out of stack space.");
        }
        return this.container.asSlice(this.pointer, byteSize, 1L);
    }

    public MemorySegment allocate(MemoryLayout layout) {
        Objects.requireNonNull(layout);
        return this.allocate(layout.byteSize(), layout.byteAlignment());
    }

    public MemorySegment allocate(MemoryLayout elementLayout, long count) {
        Objects.requireNonNull(elementLayout);
        if (count < 0L) {
            throw new IllegalArgumentException("Negative array size");
        }
        SequenceLayout layout = MemoryLayout.sequenceLayout(count, elementLayout);
        return this.allocate(layout.byteSize(), layout.byteAlignment());
    }

    public MemorySegment calloc(long byteSize) {
        return this.allocate(byteSize).fill((byte)0);
    }

    public MemorySegment calloc(long byteSize, long byteAlignment) {
        return this.allocate(byteSize, byteAlignment).fill((byte)0);
    }

    public MemorySegment calloc(MemoryLayout layout) {
        return this.allocate(layout).fill((byte)0);
    }

    public MemorySegment calloc(MemoryLayout elementLayout, long count) {
        return this.allocate(elementLayout, count).fill((byte)0);
    }

    public static SegmentStack stackGet() {
        return (SegmentStack)TLS.get();
    }

    public static SegmentStack stackPush() {
        return SegmentStack.stackGet().push();
    }

    static {
        if (DEFAULT_STACK_SIZE < 0L) {
            throw new IllegalStateException("Invalid stack size.");
        }
    }
}

