/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_UserEvent
extends Struct<SDL_UserEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int CODE;
    public static final int DATA1;
    public static final int DATA2;

    protected SDL_UserEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_UserEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_UserEvent(address, container);
    }

    public SDL_UserEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_UserEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int type() {
        return SDL_UserEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_UserEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_UserEvent.nwindowID(this.address());
    }

    @NativeType(value="Sint32")
    public int code() {
        return SDL_UserEvent.ncode(this.address());
    }

    @NativeType(value="void *")
    public long data1() {
        return SDL_UserEvent.ndata1(this.address());
    }

    @NativeType(value="void *")
    public long data2() {
        return SDL_UserEvent.ndata2(this.address());
    }

    public SDL_UserEvent type(@NativeType(value="Uint32") int value) {
        SDL_UserEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_UserEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_UserEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_UserEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_UserEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_UserEvent code(@NativeType(value="Sint32") int value) {
        SDL_UserEvent.ncode(this.address(), value);
        return this;
    }

    public SDL_UserEvent data1(@NativeType(value="void *") long value) {
        SDL_UserEvent.ndata1(this.address(), value);
        return this;
    }

    public SDL_UserEvent data2(@NativeType(value="void *") long value) {
        SDL_UserEvent.ndata2(this.address(), value);
        return this;
    }

    public SDL_UserEvent set(int type, long timestamp, int windowID, int code, long data1, long data2) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.code(code);
        this.data1(data1);
        this.data2(data2);
        return this;
    }

    public SDL_UserEvent set(SDL_UserEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_UserEvent malloc() {
        return new SDL_UserEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_UserEvent calloc() {
        return new SDL_UserEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_UserEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_UserEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_UserEvent create(long address) {
        return new SDL_UserEvent(address, null);
    }

    public static @Nullable SDL_UserEvent createSafe(long address) {
        return address == 0L ? null : new SDL_UserEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_UserEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_UserEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_UserEvent malloc(MemoryStack stack) {
        return new SDL_UserEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_UserEvent calloc(MemoryStack stack) {
        return new SDL_UserEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WINDOWID);
    }

    public static int ncode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CODE);
    }

    public static long ndata1(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATA1);
    }

    public static long ndata2(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATA2);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WINDOWID, value);
    }

    public static void ncode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CODE, value);
    }

    public static void ndata1(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATA1, value);
    }

    public static void ndata2(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATA2, value);
    }

    static {
        Struct.Layout layout = SDL_UserEvent.__struct(SDL_UserEvent.__member(4), SDL_UserEvent.__member(4), SDL_UserEvent.__member(8), SDL_UserEvent.__member(4), SDL_UserEvent.__member(4), SDL_UserEvent.__member(POINTER_SIZE), SDL_UserEvent.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        CODE = layout.offsetof(4);
        DATA1 = layout.offsetof(5);
        DATA2 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_UserEvent, Buffer>
    implements NativeResource {
        private static final SDL_UserEvent ELEMENT_FACTORY = SDL_UserEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_UserEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int type() {
            return SDL_UserEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_UserEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_UserEvent.nwindowID(this.address());
        }

        @NativeType(value="Sint32")
        public int code() {
            return SDL_UserEvent.ncode(this.address());
        }

        @NativeType(value="void *")
        public long data1() {
            return SDL_UserEvent.ndata1(this.address());
        }

        @NativeType(value="void *")
        public long data2() {
            return SDL_UserEvent.ndata2(this.address());
        }

        public Buffer type(@NativeType(value="Uint32") int value) {
            SDL_UserEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_UserEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_UserEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer code(@NativeType(value="Sint32") int value) {
            SDL_UserEvent.ncode(this.address(), value);
            return this;
        }

        public Buffer data1(@NativeType(value="void *") long value) {
            SDL_UserEvent.ndata1(this.address(), value);
            return this;
        }

        public Buffer data2(@NativeType(value="void *") long value) {
            SDL_UserEvent.ndata2(this.address(), value);
            return this;
        }
    }
}

