/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Texture
extends Struct<SDL_Texture>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int W;
    public static final int H;
    public static final int REFCOUNT;

    protected SDL_Texture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Texture create(long address, @Nullable ByteBuffer container) {
        return new SDL_Texture(address, container);
    }

    public SDL_Texture(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Texture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_PixelFormat")
    public int format() {
        return SDL_Texture.nformat(this.address());
    }

    public int w() {
        return SDL_Texture.nw(this.address());
    }

    public int h() {
        return SDL_Texture.nh(this.address());
    }

    public int refcount() {
        return SDL_Texture.nrefcount(this.address());
    }

    public SDL_Texture format(@NativeType(value="SDL_PixelFormat") int value) {
        SDL_Texture.nformat(this.address(), value);
        return this;
    }

    public SDL_Texture w(int value) {
        SDL_Texture.nw(this.address(), value);
        return this;
    }

    public SDL_Texture h(int value) {
        SDL_Texture.nh(this.address(), value);
        return this;
    }

    public SDL_Texture refcount(int value) {
        SDL_Texture.nrefcount(this.address(), value);
        return this;
    }

    public SDL_Texture set(int format, int w, int h, int refcount) {
        this.format(format);
        this.w(w);
        this.h(h);
        this.refcount(refcount);
        return this;
    }

    public SDL_Texture set(SDL_Texture src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_Texture malloc() {
        return new SDL_Texture(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Texture calloc() {
        return new SDL_Texture(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Texture create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Texture(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Texture create(long address) {
        return new SDL_Texture(address, null);
    }

    public static @Nullable SDL_Texture createSafe(long address) {
        return address == 0L ? null : new SDL_Texture(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Texture.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Texture.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Texture malloc(MemoryStack stack) {
        return new SDL_Texture(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Texture calloc(MemoryStack stack) {
        return new SDL_Texture(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static int nrefcount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFCOUNT);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    public static void nrefcount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFCOUNT, value);
    }

    static {
        Struct.Layout layout = SDL_Texture.__struct(SDL_Texture.__member(4), SDL_Texture.__member(4), SDL_Texture.__member(4), SDL_Texture.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        REFCOUNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_Texture, Buffer>
    implements NativeResource {
        private static final SDL_Texture ELEMENT_FACTORY = SDL_Texture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Texture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_PixelFormat")
        public int format() {
            return SDL_Texture.nformat(this.address());
        }

        public int w() {
            return SDL_Texture.nw(this.address());
        }

        public int h() {
            return SDL_Texture.nh(this.address());
        }

        public int refcount() {
            return SDL_Texture.nrefcount(this.address());
        }

        public Buffer format(@NativeType(value="SDL_PixelFormat") int value) {
            SDL_Texture.nformat(this.address(), value);
            return this;
        }

        public Buffer w(int value) {
            SDL_Texture.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            SDL_Texture.nh(this.address(), value);
            return this;
        }

        public Buffer refcount(int value) {
            SDL_Texture.nrefcount(this.address(), value);
            return this;
        }
    }
}

