/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_TextEditingEvent
extends Struct<SDL_TextEditingEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int TEXT;
    public static final int START;
    public static final int LENGTH;

    protected SDL_TextEditingEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_TextEditingEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_TextEditingEvent(address, container);
    }

    public SDL_TextEditingEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_TextEditingEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_TextEditingEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_TextEditingEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_TextEditingEvent.nwindowID(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer text() {
        return SDL_TextEditingEvent.ntext(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String textString() {
        return SDL_TextEditingEvent.ntextString(this.address());
    }

    @NativeType(value="Sint32")
    public int start() {
        return SDL_TextEditingEvent.nstart(this.address());
    }

    @NativeType(value="Sint32")
    public int length() {
        return SDL_TextEditingEvent.nlength(this.address());
    }

    public SDL_TextEditingEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_TextEditingEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_TextEditingEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_TextEditingEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent text(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        SDL_TextEditingEvent.ntext(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent start(@NativeType(value="Sint32") int value) {
        SDL_TextEditingEvent.nstart(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent length(@NativeType(value="Sint32") int value) {
        SDL_TextEditingEvent.nlength(this.address(), value);
        return this;
    }

    public SDL_TextEditingEvent set(int type, long timestamp, int windowID, @Nullable ByteBuffer text, int start, int length) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.text(text);
        this.start(start);
        this.length(length);
        return this;
    }

    public SDL_TextEditingEvent set(SDL_TextEditingEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_TextEditingEvent malloc() {
        return new SDL_TextEditingEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_TextEditingEvent calloc() {
        return new SDL_TextEditingEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_TextEditingEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_TextEditingEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_TextEditingEvent create(long address) {
        return new SDL_TextEditingEvent(address, null);
    }

    public static @Nullable SDL_TextEditingEvent createSafe(long address) {
        return address == 0L ? null : new SDL_TextEditingEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_TextEditingEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_TextEditingEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_TextEditingEvent malloc(MemoryStack stack) {
        return new SDL_TextEditingEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_TextEditingEvent calloc(MemoryStack stack) {
        return new SDL_TextEditingEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WINDOWID);
    }

    public static @Nullable ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)TEXT));
    }

    public static @Nullable String ntextString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)TEXT));
    }

    public static int nstart(long struct) {
        return MemoryUtil.memGetInt(struct + (long)START);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LENGTH);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WINDOWID, value);
    }

    public static void ntext(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)TEXT, MemoryUtil.memAddressSafe(value));
    }

    public static void nstart(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)START, value);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LENGTH, value);
    }

    static {
        Struct.Layout layout = SDL_TextEditingEvent.__struct(SDL_TextEditingEvent.__member(4), SDL_TextEditingEvent.__member(4), SDL_TextEditingEvent.__member(8), SDL_TextEditingEvent.__member(4), SDL_TextEditingEvent.__member(POINTER_SIZE), SDL_TextEditingEvent.__member(4), SDL_TextEditingEvent.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        TEXT = layout.offsetof(4);
        START = layout.offsetof(5);
        LENGTH = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_TextEditingEvent, Buffer>
    implements NativeResource {
        private static final SDL_TextEditingEvent ELEMENT_FACTORY = SDL_TextEditingEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_TextEditingEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_TextEditingEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_TextEditingEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_TextEditingEvent.nwindowID(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer text() {
            return SDL_TextEditingEvent.ntext(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String textString() {
            return SDL_TextEditingEvent.ntextString(this.address());
        }

        @NativeType(value="Sint32")
        public int start() {
            return SDL_TextEditingEvent.nstart(this.address());
        }

        @NativeType(value="Sint32")
        public int length() {
            return SDL_TextEditingEvent.nlength(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_TextEditingEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_TextEditingEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_TextEditingEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer text(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            SDL_TextEditingEvent.ntext(this.address(), value);
            return this;
        }

        public Buffer start(@NativeType(value="Sint32") int value) {
            SDL_TextEditingEvent.nstart(this.address(), value);
            return this;
        }

        public Buffer length(@NativeType(value="Sint32") int value) {
            SDL_TextEditingEvent.nlength(this.address(), value);
            return this;
        }
    }
}

