/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_SensorEvent
extends Struct<SDL_SensorEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WHICH;
    public static final int DATA;
    public static final int SENSOR_TIMESTAMP;

    protected SDL_SensorEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_SensorEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_SensorEvent(address, container);
    }

    public SDL_SensorEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_SensorEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_SensorEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_SensorEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_SensorID")
    public int which() {
        return SDL_SensorEvent.nwhich(this.address());
    }

    @NativeType(value="float[6]")
    public FloatBuffer data() {
        return SDL_SensorEvent.ndata(this.address());
    }

    public float data(int index) {
        return SDL_SensorEvent.ndata(this.address(), index);
    }

    @NativeType(value="Uint64")
    public long sensor_timestamp() {
        return SDL_SensorEvent.nsensor_timestamp(this.address());
    }

    public SDL_SensorEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_SensorEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_SensorEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_SensorEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_SensorEvent which(@NativeType(value="SDL_SensorID") int value) {
        SDL_SensorEvent.nwhich(this.address(), value);
        return this;
    }

    public SDL_SensorEvent data(@NativeType(value="float[6]") FloatBuffer value) {
        SDL_SensorEvent.ndata(this.address(), value);
        return this;
    }

    public SDL_SensorEvent data(int index, float value) {
        SDL_SensorEvent.ndata(this.address(), index, value);
        return this;
    }

    public SDL_SensorEvent sensor_timestamp(@NativeType(value="Uint64") long value) {
        SDL_SensorEvent.nsensor_timestamp(this.address(), value);
        return this;
    }

    public SDL_SensorEvent set(int type, long timestamp, int which, FloatBuffer data, long sensor_timestamp) {
        this.type(type);
        this.timestamp(timestamp);
        this.which(which);
        this.data(data);
        this.sensor_timestamp(sensor_timestamp);
        return this;
    }

    public SDL_SensorEvent set(SDL_SensorEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_SensorEvent malloc() {
        return new SDL_SensorEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_SensorEvent calloc() {
        return new SDL_SensorEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_SensorEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_SensorEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_SensorEvent create(long address) {
        return new SDL_SensorEvent(address, null);
    }

    public static @Nullable SDL_SensorEvent createSafe(long address) {
        return address == 0L ? null : new SDL_SensorEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_SensorEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_SensorEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_SensorEvent malloc(MemoryStack stack) {
        return new SDL_SensorEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_SensorEvent calloc(MemoryStack stack) {
        return new SDL_SensorEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwhich(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WHICH);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)DATA, 6);
    }

    public static float ndata(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)DATA + Checks.check(index, 6) * 4L);
    }

    public static long nsensor_timestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SENSOR_TIMESTAMP);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwhich(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WHICH, value);
    }

    public static void ndata(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining() * 4);
    }

    public static void ndata(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)DATA + Checks.check(index, 6) * 4L, value);
    }

    public static void nsensor_timestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SENSOR_TIMESTAMP, value);
    }

    static {
        Struct.Layout layout = SDL_SensorEvent.__struct(SDL_SensorEvent.__member(4), SDL_SensorEvent.__member(4), SDL_SensorEvent.__member(8), SDL_SensorEvent.__member(4), SDL_SensorEvent.__array(4, 6), SDL_SensorEvent.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WHICH = layout.offsetof(3);
        DATA = layout.offsetof(4);
        SENSOR_TIMESTAMP = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_SensorEvent, Buffer>
    implements NativeResource {
        private static final SDL_SensorEvent ELEMENT_FACTORY = SDL_SensorEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_SensorEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_SensorEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_SensorEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_SensorID")
        public int which() {
            return SDL_SensorEvent.nwhich(this.address());
        }

        @NativeType(value="float[6]")
        public FloatBuffer data() {
            return SDL_SensorEvent.ndata(this.address());
        }

        public float data(int index) {
            return SDL_SensorEvent.ndata(this.address(), index);
        }

        @NativeType(value="Uint64")
        public long sensor_timestamp() {
            return SDL_SensorEvent.nsensor_timestamp(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_SensorEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_SensorEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer which(@NativeType(value="SDL_SensorID") int value) {
            SDL_SensorEvent.nwhich(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="float[6]") FloatBuffer value) {
            SDL_SensorEvent.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, float value) {
            SDL_SensorEvent.ndata(this.address(), index, value);
            return this;
        }

        public Buffer sensor_timestamp(@NativeType(value="Uint64") long value) {
            SDL_SensorEvent.nsensor_timestamp(this.address(), value);
            return this;
        }
    }
}

