/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Rect
extends Struct<SDL_Rect>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    protected SDL_Rect(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Rect create(long address, @Nullable ByteBuffer container) {
        return new SDL_Rect(address, container);
    }

    public SDL_Rect(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Rect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return SDL_Rect.nx(this.address());
    }

    public int y() {
        return SDL_Rect.ny(this.address());
    }

    public int w() {
        return SDL_Rect.nw(this.address());
    }

    public int h() {
        return SDL_Rect.nh(this.address());
    }

    public SDL_Rect x(int value) {
        SDL_Rect.nx(this.address(), value);
        return this;
    }

    public SDL_Rect y(int value) {
        SDL_Rect.ny(this.address(), value);
        return this;
    }

    public SDL_Rect w(int value) {
        SDL_Rect.nw(this.address(), value);
        return this;
    }

    public SDL_Rect h(int value) {
        SDL_Rect.nh(this.address(), value);
        return this;
    }

    public SDL_Rect set(int x, int y, int w, int h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public SDL_Rect set(SDL_Rect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_Rect malloc() {
        return new SDL_Rect(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Rect calloc() {
        return new SDL_Rect(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Rect create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Rect(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Rect create(long address) {
        return new SDL_Rect(address, null);
    }

    public static @Nullable SDL_Rect createSafe(long address) {
        return address == 0L ? null : new SDL_Rect(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Rect.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Rect.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Rect malloc(MemoryStack stack) {
        return new SDL_Rect(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Rect calloc(MemoryStack stack) {
        return new SDL_Rect(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = SDL_Rect.__struct(SDL_Rect.__member(4), SDL_Rect.__member(4), SDL_Rect.__member(4), SDL_Rect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_Rect, Buffer>
    implements NativeResource {
        private static final SDL_Rect ELEMENT_FACTORY = SDL_Rect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Rect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int x() {
            return SDL_Rect.nx(this.address());
        }

        public int y() {
            return SDL_Rect.ny(this.address());
        }

        public int w() {
            return SDL_Rect.nw(this.address());
        }

        public int h() {
            return SDL_Rect.nh(this.address());
        }

        public Buffer x(int value) {
            SDL_Rect.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            SDL_Rect.ny(this.address(), value);
            return this;
        }

        public Buffer w(int value) {
            SDL_Rect.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            SDL_Rect.nh(this.address(), value);
            return this;
        }
    }
}

