/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_MessageBoxButtonData
extends Struct<SDL_MessageBoxButtonData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int BUTTONID;
    public static final int TEXT;

    protected SDL_MessageBoxButtonData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_MessageBoxButtonData create(long address, @Nullable ByteBuffer container) {
        return new SDL_MessageBoxButtonData(address, container);
    }

    public SDL_MessageBoxButtonData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_MessageBoxButtonData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_MessageBoxButtonFlags")
    public int flags() {
        return SDL_MessageBoxButtonData.nflags(this.address());
    }

    public int buttonID() {
        return SDL_MessageBoxButtonData.nbuttonID(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer text() {
        return SDL_MessageBoxButtonData.ntext(this.address());
    }

    @NativeType(value="char const *")
    public String textString() {
        return SDL_MessageBoxButtonData.ntextString(this.address());
    }

    public SDL_MessageBoxButtonData flags(@NativeType(value="SDL_MessageBoxButtonFlags") int value) {
        SDL_MessageBoxButtonData.nflags(this.address(), value);
        return this;
    }

    public SDL_MessageBoxButtonData buttonID(int value) {
        SDL_MessageBoxButtonData.nbuttonID(this.address(), value);
        return this;
    }

    public SDL_MessageBoxButtonData text(@NativeType(value="char const *") ByteBuffer value) {
        SDL_MessageBoxButtonData.ntext(this.address(), value);
        return this;
    }

    public SDL_MessageBoxButtonData set(int flags, int buttonID, ByteBuffer text) {
        this.flags(flags);
        this.buttonID(buttonID);
        this.text(text);
        return this;
    }

    public SDL_MessageBoxButtonData set(SDL_MessageBoxButtonData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_MessageBoxButtonData malloc() {
        return new SDL_MessageBoxButtonData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_MessageBoxButtonData calloc() {
        return new SDL_MessageBoxButtonData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_MessageBoxButtonData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_MessageBoxButtonData(MemoryUtil.memAddress(container), container);
    }

    public static SDL_MessageBoxButtonData create(long address) {
        return new SDL_MessageBoxButtonData(address, null);
    }

    public static @Nullable SDL_MessageBoxButtonData createSafe(long address) {
        return address == 0L ? null : new SDL_MessageBoxButtonData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_MessageBoxButtonData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_MessageBoxButtonData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_MessageBoxButtonData malloc(MemoryStack stack) {
        return new SDL_MessageBoxButtonData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_MessageBoxButtonData calloc(MemoryStack stack) {
        return new SDL_MessageBoxButtonData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nbuttonID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTONID);
    }

    public static ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)TEXT));
    }

    public static String ntextString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)TEXT));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nbuttonID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUTTONID, value);
    }

    public static void ntext(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)TEXT, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TEXT));
    }

    static {
        Struct.Layout layout = SDL_MessageBoxButtonData.__struct(SDL_MessageBoxButtonData.__member(4), SDL_MessageBoxButtonData.__member(4), SDL_MessageBoxButtonData.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        BUTTONID = layout.offsetof(1);
        TEXT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SDL_MessageBoxButtonData, Buffer>
    implements NativeResource {
        private static final SDL_MessageBoxButtonData ELEMENT_FACTORY = SDL_MessageBoxButtonData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_MessageBoxButtonData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_MessageBoxButtonFlags")
        public int flags() {
            return SDL_MessageBoxButtonData.nflags(this.address());
        }

        public int buttonID() {
            return SDL_MessageBoxButtonData.nbuttonID(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer text() {
            return SDL_MessageBoxButtonData.ntext(this.address());
        }

        @NativeType(value="char const *")
        public String textString() {
            return SDL_MessageBoxButtonData.ntextString(this.address());
        }

        public Buffer flags(@NativeType(value="SDL_MessageBoxButtonFlags") int value) {
            SDL_MessageBoxButtonData.nflags(this.address(), value);
            return this;
        }

        public Buffer buttonID(int value) {
            SDL_MessageBoxButtonData.nbuttonID(this.address(), value);
            return this;
        }

        public Buffer text(@NativeType(value="char const *") ByteBuffer value) {
            SDL_MessageBoxButtonData.ntext(this.address(), value);
            return this;
        }
    }
}

