/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Locale
extends Struct<SDL_Locale>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LANGUAGE;
    public static final int COUNTRY;

    protected SDL_Locale(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Locale create(long address, @Nullable ByteBuffer container) {
        return new SDL_Locale(address, container);
    }

    public SDL_Locale(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Locale.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer language() {
        return SDL_Locale.nlanguage(this.address());
    }

    @NativeType(value="char const *")
    public String languageString() {
        return SDL_Locale.nlanguageString(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer country() {
        return SDL_Locale.ncountry(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String countryString() {
        return SDL_Locale.ncountryString(this.address());
    }

    public SDL_Locale language(@NativeType(value="char const *") ByteBuffer value) {
        SDL_Locale.nlanguage(this.address(), value);
        return this;
    }

    public SDL_Locale country(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        SDL_Locale.ncountry(this.address(), value);
        return this;
    }

    public SDL_Locale set(ByteBuffer language, @Nullable ByteBuffer country) {
        this.language(language);
        this.country(country);
        return this;
    }

    public SDL_Locale set(SDL_Locale src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_Locale malloc() {
        return new SDL_Locale(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Locale calloc() {
        return new SDL_Locale(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Locale create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Locale(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Locale create(long address) {
        return new SDL_Locale(address, null);
    }

    public static @Nullable SDL_Locale createSafe(long address) {
        return address == 0L ? null : new SDL_Locale(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Locale.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Locale.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Locale malloc(MemoryStack stack) {
        return new SDL_Locale(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Locale calloc(MemoryStack stack) {
        return new SDL_Locale(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nlanguage(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)LANGUAGE));
    }

    public static String nlanguageString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)LANGUAGE));
    }

    public static @Nullable ByteBuffer ncountry(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)COUNTRY));
    }

    public static @Nullable String ncountryString(long struct) {
        return MemoryUtil.memASCIISafe(MemoryUtil.memGetAddress(struct + (long)COUNTRY));
    }

    public static void nlanguage(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)LANGUAGE, MemoryUtil.memAddress(value));
    }

    public static void ncountry(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)COUNTRY, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LANGUAGE));
    }

    static {
        Struct.Layout layout = SDL_Locale.__struct(SDL_Locale.__member(POINTER_SIZE), SDL_Locale.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LANGUAGE = layout.offsetof(0);
        COUNTRY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_Locale, Buffer>
    implements NativeResource {
        private static final SDL_Locale ELEMENT_FACTORY = SDL_Locale.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Locale getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer language() {
            return SDL_Locale.nlanguage(this.address());
        }

        @NativeType(value="char const *")
        public String languageString() {
            return SDL_Locale.nlanguageString(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer country() {
            return SDL_Locale.ncountry(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String countryString() {
            return SDL_Locale.ncountryString(this.address());
        }

        public Buffer language(@NativeType(value="char const *") ByteBuffer value) {
            SDL_Locale.nlanguage(this.address(), value);
            return this;
        }

        public Buffer country(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            SDL_Locale.ncountry(this.address(), value);
            return this;
        }
    }
}

