/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_KeyboardEvent
extends Struct<SDL_KeyboardEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int WHICH;
    public static final int SCANCODE;
    public static final int KEY;
    public static final int MOD;
    public static final int RAW;
    public static final int DOWN;
    public static final int REPEAT;

    protected SDL_KeyboardEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_KeyboardEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_KeyboardEvent(address, container);
    }

    public SDL_KeyboardEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_KeyboardEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_KeyboardEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_KeyboardEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_KeyboardEvent.nwindowID(this.address());
    }

    @NativeType(value="SDL_KeyboardID")
    public int which() {
        return SDL_KeyboardEvent.nwhich(this.address());
    }

    @NativeType(value="SDL_Scancode")
    public int scancode() {
        return SDL_KeyboardEvent.nscancode(this.address());
    }

    @NativeType(value="SDL_Keycode")
    public int key() {
        return SDL_KeyboardEvent.nkey(this.address());
    }

    @NativeType(value="SDL_Keymod")
    public short mod() {
        return SDL_KeyboardEvent.nmod(this.address());
    }

    @NativeType(value="Uint16")
    public short raw() {
        return SDL_KeyboardEvent.nraw(this.address());
    }

    @NativeType(value="bool")
    public boolean down() {
        return SDL_KeyboardEvent.ndown(this.address());
    }

    @NativeType(value="bool")
    public boolean repeat() {
        return SDL_KeyboardEvent.nrepeat(this.address());
    }

    public SDL_KeyboardEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_KeyboardEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_KeyboardEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_KeyboardEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent which(@NativeType(value="SDL_KeyboardID") int value) {
        SDL_KeyboardEvent.nwhich(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent scancode(@NativeType(value="SDL_Scancode") int value) {
        SDL_KeyboardEvent.nscancode(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent key(@NativeType(value="SDL_Keycode") int value) {
        SDL_KeyboardEvent.nkey(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent mod(@NativeType(value="SDL_Keymod") short value) {
        SDL_KeyboardEvent.nmod(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent raw(@NativeType(value="Uint16") short value) {
        SDL_KeyboardEvent.nraw(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent down(@NativeType(value="bool") boolean value) {
        SDL_KeyboardEvent.ndown(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent repeat(@NativeType(value="bool") boolean value) {
        SDL_KeyboardEvent.nrepeat(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent set(int type, long timestamp, int windowID, int which, int scancode, int key, short mod, short raw, boolean down, boolean repeat) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.which(which);
        this.scancode(scancode);
        this.key(key);
        this.mod(mod);
        this.raw(raw);
        this.down(down);
        this.repeat(repeat);
        return this;
    }

    public SDL_KeyboardEvent set(SDL_KeyboardEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_KeyboardEvent malloc() {
        return new SDL_KeyboardEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_KeyboardEvent calloc() {
        return new SDL_KeyboardEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_KeyboardEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_KeyboardEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_KeyboardEvent create(long address) {
        return new SDL_KeyboardEvent(address, null);
    }

    public static @Nullable SDL_KeyboardEvent createSafe(long address) {
        return address == 0L ? null : new SDL_KeyboardEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_KeyboardEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_KeyboardEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_KeyboardEvent malloc(MemoryStack stack) {
        return new SDL_KeyboardEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_KeyboardEvent calloc(MemoryStack stack) {
        return new SDL_KeyboardEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WINDOWID);
    }

    public static int nwhich(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WHICH);
    }

    public static int nscancode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCANCODE);
    }

    public static int nkey(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KEY);
    }

    public static short nmod(long struct) {
        return MemoryUtil.memGetShort(struct + (long)MOD);
    }

    public static short nraw(long struct) {
        return MemoryUtil.memGetShort(struct + (long)RAW);
    }

    public static boolean ndown(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DOWN) != 0;
    }

    public static boolean nrepeat(long struct) {
        return MemoryUtil.memGetByte(struct + (long)REPEAT) != 0;
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WINDOWID, value);
    }

    public static void nwhich(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WHICH, value);
    }

    public static void nscancode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCANCODE, value);
    }

    public static void nkey(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)KEY, value);
    }

    public static void nmod(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)MOD, value);
    }

    public static void nraw(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)RAW, value);
    }

    public static void ndown(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)DOWN, value ? (byte)1 : 0);
    }

    public static void nrepeat(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)REPEAT, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = SDL_KeyboardEvent.__struct(SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(8), SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(4), SDL_KeyboardEvent.__member(2), SDL_KeyboardEvent.__member(2), SDL_KeyboardEvent.__member(1), SDL_KeyboardEvent.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        WHICH = layout.offsetof(4);
        SCANCODE = layout.offsetof(5);
        KEY = layout.offsetof(6);
        MOD = layout.offsetof(7);
        RAW = layout.offsetof(8);
        DOWN = layout.offsetof(9);
        REPEAT = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<SDL_KeyboardEvent, Buffer>
    implements NativeResource {
        private static final SDL_KeyboardEvent ELEMENT_FACTORY = SDL_KeyboardEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_KeyboardEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_KeyboardEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_KeyboardEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_KeyboardEvent.nwindowID(this.address());
        }

        @NativeType(value="SDL_KeyboardID")
        public int which() {
            return SDL_KeyboardEvent.nwhich(this.address());
        }

        @NativeType(value="SDL_Scancode")
        public int scancode() {
            return SDL_KeyboardEvent.nscancode(this.address());
        }

        @NativeType(value="SDL_Keycode")
        public int key() {
            return SDL_KeyboardEvent.nkey(this.address());
        }

        @NativeType(value="SDL_Keymod")
        public short mod() {
            return SDL_KeyboardEvent.nmod(this.address());
        }

        @NativeType(value="Uint16")
        public short raw() {
            return SDL_KeyboardEvent.nraw(this.address());
        }

        @NativeType(value="bool")
        public boolean down() {
            return SDL_KeyboardEvent.ndown(this.address());
        }

        @NativeType(value="bool")
        public boolean repeat() {
            return SDL_KeyboardEvent.nrepeat(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_KeyboardEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_KeyboardEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_KeyboardEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer which(@NativeType(value="SDL_KeyboardID") int value) {
            SDL_KeyboardEvent.nwhich(this.address(), value);
            return this;
        }

        public Buffer scancode(@NativeType(value="SDL_Scancode") int value) {
            SDL_KeyboardEvent.nscancode(this.address(), value);
            return this;
        }

        public Buffer key(@NativeType(value="SDL_Keycode") int value) {
            SDL_KeyboardEvent.nkey(this.address(), value);
            return this;
        }

        public Buffer mod(@NativeType(value="SDL_Keymod") short value) {
            SDL_KeyboardEvent.nmod(this.address(), value);
            return this;
        }

        public Buffer raw(@NativeType(value="Uint16") short value) {
            SDL_KeyboardEvent.nraw(this.address(), value);
            return this;
        }

        public Buffer down(@NativeType(value="bool") boolean value) {
            SDL_KeyboardEvent.ndown(this.address(), value);
            return this;
        }

        public Buffer repeat(@NativeType(value="bool") boolean value) {
            SDL_KeyboardEvent.nrepeat(this.address(), value);
            return this;
        }
    }
}

