/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_HapticDirection;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_HapticCustom
extends Struct<SDL_HapticCustom>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DIRECTION;
    public static final int LENGTH;
    public static final int DELAY;
    public static final int BUTTON;
    public static final int INTERVAL;
    public static final int CHANNELS;
    public static final int PERIOD;
    public static final int SAMPLES;
    public static final int DATA;
    public static final int ATTACK_LENGTH;
    public static final int ATTACK_LEVEL;
    public static final int FADE_LENGTH;
    public static final int FADE_LEVEL;

    protected SDL_HapticCustom(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_HapticCustom create(long address, @Nullable ByteBuffer container) {
        return new SDL_HapticCustom(address, container);
    }

    public SDL_HapticCustom(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_HapticCustom.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_HapticEffectType")
    public short type() {
        return SDL_HapticCustom.ntype(this.address());
    }

    public SDL_HapticDirection direction() {
        return SDL_HapticCustom.ndirection(this.address());
    }

    @NativeType(value="Uint32")
    public int length() {
        return SDL_HapticCustom.nlength(this.address());
    }

    @NativeType(value="Uint16")
    public short delay() {
        return SDL_HapticCustom.ndelay(this.address());
    }

    @NativeType(value="Uint16")
    public short button() {
        return SDL_HapticCustom.nbutton(this.address());
    }

    @NativeType(value="Uint16")
    public short interval() {
        return SDL_HapticCustom.ninterval(this.address());
    }

    @NativeType(value="Uint8")
    public byte channels() {
        return SDL_HapticCustom.nchannels(this.address());
    }

    @NativeType(value="Uint16")
    public short period() {
        return SDL_HapticCustom.nperiod(this.address());
    }

    @NativeType(value="Uint16")
    public short samples() {
        return SDL_HapticCustom.nsamples(this.address());
    }

    @NativeType(value="Uint16 *")
    public ShortBuffer data() {
        return SDL_HapticCustom.ndata(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_length() {
        return SDL_HapticCustom.nattack_length(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_level() {
        return SDL_HapticCustom.nattack_level(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_length() {
        return SDL_HapticCustom.nfade_length(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_level() {
        return SDL_HapticCustom.nfade_level(this.address());
    }

    public SDL_HapticCustom type(@NativeType(value="SDL_HapticEffectType") short value) {
        SDL_HapticCustom.ntype(this.address(), value);
        return this;
    }

    public SDL_HapticCustom direction(SDL_HapticDirection value) {
        SDL_HapticCustom.ndirection(this.address(), value);
        return this;
    }

    public SDL_HapticCustom direction(Consumer<SDL_HapticDirection> consumer) {
        consumer.accept(this.direction());
        return this;
    }

    public SDL_HapticCustom length(@NativeType(value="Uint32") int value) {
        SDL_HapticCustom.nlength(this.address(), value);
        return this;
    }

    public SDL_HapticCustom delay(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.ndelay(this.address(), value);
        return this;
    }

    public SDL_HapticCustom button(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nbutton(this.address(), value);
        return this;
    }

    public SDL_HapticCustom interval(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.ninterval(this.address(), value);
        return this;
    }

    public SDL_HapticCustom channels(@NativeType(value="Uint8") byte value) {
        SDL_HapticCustom.nchannels(this.address(), value);
        return this;
    }

    public SDL_HapticCustom period(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nperiod(this.address(), value);
        return this;
    }

    public SDL_HapticCustom samples(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nsamples(this.address(), value);
        return this;
    }

    public SDL_HapticCustom data(@NativeType(value="Uint16 *") ShortBuffer value) {
        SDL_HapticCustom.ndata(this.address(), value);
        return this;
    }

    public SDL_HapticCustom attack_length(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nattack_length(this.address(), value);
        return this;
    }

    public SDL_HapticCustom attack_level(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nattack_level(this.address(), value);
        return this;
    }

    public SDL_HapticCustom fade_length(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nfade_length(this.address(), value);
        return this;
    }

    public SDL_HapticCustom fade_level(@NativeType(value="Uint16") short value) {
        SDL_HapticCustom.nfade_level(this.address(), value);
        return this;
    }

    public SDL_HapticCustom set(short type, SDL_HapticDirection direction, int length, short delay, short button, short interval, byte channels, short period, short samples, ShortBuffer data, short attack_length, short attack_level, short fade_length, short fade_level) {
        this.type(type);
        this.direction(direction);
        this.length(length);
        this.delay(delay);
        this.button(button);
        this.interval(interval);
        this.channels(channels);
        this.period(period);
        this.samples(samples);
        this.data(data);
        this.attack_length(attack_length);
        this.attack_level(attack_level);
        this.fade_length(fade_length);
        this.fade_level(fade_level);
        return this;
    }

    public SDL_HapticCustom set(SDL_HapticCustom src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_HapticCustom malloc() {
        return new SDL_HapticCustom(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_HapticCustom calloc() {
        return new SDL_HapticCustom(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_HapticCustom create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_HapticCustom(MemoryUtil.memAddress(container), container);
    }

    public static SDL_HapticCustom create(long address) {
        return new SDL_HapticCustom(address, null);
    }

    public static @Nullable SDL_HapticCustom createSafe(long address) {
        return address == 0L ? null : new SDL_HapticCustom(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_HapticCustom.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_HapticCustom.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_HapticCustom malloc(MemoryStack stack) {
        return new SDL_HapticCustom(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_HapticCustom calloc(MemoryStack stack) {
        return new SDL_HapticCustom(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short ntype(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TYPE);
    }

    public static SDL_HapticDirection ndirection(long struct) {
        return SDL_HapticDirection.create(struct + (long)DIRECTION);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LENGTH);
    }

    public static short ndelay(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DELAY);
    }

    public static short nbutton(long struct) {
        return MemoryUtil.memGetShort(struct + (long)BUTTON);
    }

    public static short ninterval(long struct) {
        return MemoryUtil.memGetShort(struct + (long)INTERVAL);
    }

    public static byte nchannels(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CHANNELS);
    }

    public static short nperiod(long struct) {
        return MemoryUtil.memGetShort(struct + (long)PERIOD);
    }

    public static short nsamples(long struct) {
        return MemoryUtil.memGetShort(struct + (long)SAMPLES);
    }

    public static ShortBuffer ndata(long struct) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), Byte.toUnsignedInt(SDL_HapticCustom.nchannels(struct)) * Short.toUnsignedInt(SDL_HapticCustom.nsamples(struct)));
    }

    public static short nattack_length(long struct) {
        return MemoryUtil.memGetShort(struct + (long)ATTACK_LENGTH);
    }

    public static short nattack_level(long struct) {
        return MemoryUtil.memGetShort(struct + (long)ATTACK_LEVEL);
    }

    public static short nfade_length(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FADE_LENGTH);
    }

    public static short nfade_level(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FADE_LEVEL);
    }

    public static void ntype(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)TYPE, value);
    }

    public static void ndirection(long struct, SDL_HapticDirection value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DIRECTION, SDL_HapticDirection.SIZEOF);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LENGTH, value);
    }

    public static void ndelay(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)DELAY, value);
    }

    public static void nbutton(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)BUTTON, value);
    }

    public static void ninterval(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)INTERVAL, value);
    }

    public static void nchannels(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)CHANNELS, value);
    }

    public static void nperiod(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)PERIOD, value);
    }

    public static void nsamples(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)SAMPLES, value);
    }

    public static void ndata(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
    }

    public static void nattack_length(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)ATTACK_LENGTH, value);
    }

    public static void nattack_level(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)ATTACK_LEVEL, value);
    }

    public static void nfade_length(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)FADE_LENGTH, value);
    }

    public static void nfade_level(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)FADE_LEVEL, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = SDL_HapticCustom.__struct(SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(SDL_HapticDirection.SIZEOF, SDL_HapticDirection.ALIGNOF), SDL_HapticCustom.__member(4), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(1), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(POINTER_SIZE), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2), SDL_HapticCustom.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DIRECTION = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
        DELAY = layout.offsetof(3);
        BUTTON = layout.offsetof(4);
        INTERVAL = layout.offsetof(5);
        CHANNELS = layout.offsetof(6);
        PERIOD = layout.offsetof(7);
        SAMPLES = layout.offsetof(8);
        DATA = layout.offsetof(9);
        ATTACK_LENGTH = layout.offsetof(10);
        ATTACK_LEVEL = layout.offsetof(11);
        FADE_LENGTH = layout.offsetof(12);
        FADE_LEVEL = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<SDL_HapticCustom, Buffer>
    implements NativeResource {
        private static final SDL_HapticCustom ELEMENT_FACTORY = SDL_HapticCustom.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_HapticCustom getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_HapticEffectType")
        public short type() {
            return SDL_HapticCustom.ntype(this.address());
        }

        public SDL_HapticDirection direction() {
            return SDL_HapticCustom.ndirection(this.address());
        }

        @NativeType(value="Uint32")
        public int length() {
            return SDL_HapticCustom.nlength(this.address());
        }

        @NativeType(value="Uint16")
        public short delay() {
            return SDL_HapticCustom.ndelay(this.address());
        }

        @NativeType(value="Uint16")
        public short button() {
            return SDL_HapticCustom.nbutton(this.address());
        }

        @NativeType(value="Uint16")
        public short interval() {
            return SDL_HapticCustom.ninterval(this.address());
        }

        @NativeType(value="Uint8")
        public byte channels() {
            return SDL_HapticCustom.nchannels(this.address());
        }

        @NativeType(value="Uint16")
        public short period() {
            return SDL_HapticCustom.nperiod(this.address());
        }

        @NativeType(value="Uint16")
        public short samples() {
            return SDL_HapticCustom.nsamples(this.address());
        }

        @NativeType(value="Uint16 *")
        public ShortBuffer data() {
            return SDL_HapticCustom.ndata(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_length() {
            return SDL_HapticCustom.nattack_length(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_level() {
            return SDL_HapticCustom.nattack_level(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_length() {
            return SDL_HapticCustom.nfade_length(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_level() {
            return SDL_HapticCustom.nfade_level(this.address());
        }

        public Buffer type(@NativeType(value="SDL_HapticEffectType") short value) {
            SDL_HapticCustom.ntype(this.address(), value);
            return this;
        }

        public Buffer direction(SDL_HapticDirection value) {
            SDL_HapticCustom.ndirection(this.address(), value);
            return this;
        }

        public Buffer direction(Consumer<SDL_HapticDirection> consumer) {
            consumer.accept(this.direction());
            return this;
        }

        public Buffer length(@NativeType(value="Uint32") int value) {
            SDL_HapticCustom.nlength(this.address(), value);
            return this;
        }

        public Buffer delay(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.ndelay(this.address(), value);
            return this;
        }

        public Buffer button(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nbutton(this.address(), value);
            return this;
        }

        public Buffer interval(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.ninterval(this.address(), value);
            return this;
        }

        public Buffer channels(@NativeType(value="Uint8") byte value) {
            SDL_HapticCustom.nchannels(this.address(), value);
            return this;
        }

        public Buffer period(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nperiod(this.address(), value);
            return this;
        }

        public Buffer samples(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nsamples(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="Uint16 *") ShortBuffer value) {
            SDL_HapticCustom.ndata(this.address(), value);
            return this;
        }

        public Buffer attack_length(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nattack_length(this.address(), value);
            return this;
        }

        public Buffer attack_level(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nattack_level(this.address(), value);
            return this;
        }

        public Buffer fade_length(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nfade_length(this.address(), value);
            return this;
        }

        public Buffer fade_level(@NativeType(value="Uint16") short value) {
            SDL_HapticCustom.nfade_level(this.address(), value);
            return this;
        }
    }
}

