/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GamepadSensorEvent
extends Struct<SDL_GamepadSensorEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WHICH;
    public static final int SENSOR;
    public static final int DATA;
    public static final int SENSOR_TIMESTAMP;

    protected SDL_GamepadSensorEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GamepadSensorEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_GamepadSensorEvent(address, container);
    }

    public SDL_GamepadSensorEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GamepadSensorEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_GamepadSensorEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_GamepadSensorEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_JoystickID")
    public int which() {
        return SDL_GamepadSensorEvent.nwhich(this.address());
    }

    @NativeType(value="Sint32")
    public int sensor() {
        return SDL_GamepadSensorEvent.nsensor(this.address());
    }

    @NativeType(value="float[3]")
    public FloatBuffer data() {
        return SDL_GamepadSensorEvent.ndata(this.address());
    }

    public float data(int index) {
        return SDL_GamepadSensorEvent.ndata(this.address(), index);
    }

    @NativeType(value="Uint64")
    public long sensor_timestamp() {
        return SDL_GamepadSensorEvent.nsensor_timestamp(this.address());
    }

    public SDL_GamepadSensorEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_GamepadSensorEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_GamepadSensorEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent which(@NativeType(value="SDL_JoystickID") int value) {
        SDL_GamepadSensorEvent.nwhich(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent sensor(@NativeType(value="Sint32") int value) {
        SDL_GamepadSensorEvent.nsensor(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent data(@NativeType(value="float[3]") FloatBuffer value) {
        SDL_GamepadSensorEvent.ndata(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent data(int index, float value) {
        SDL_GamepadSensorEvent.ndata(this.address(), index, value);
        return this;
    }

    public SDL_GamepadSensorEvent sensor_timestamp(@NativeType(value="Uint64") long value) {
        SDL_GamepadSensorEvent.nsensor_timestamp(this.address(), value);
        return this;
    }

    public SDL_GamepadSensorEvent set(int type, long timestamp, int which, int sensor, FloatBuffer data, long sensor_timestamp) {
        this.type(type);
        this.timestamp(timestamp);
        this.which(which);
        this.sensor(sensor);
        this.data(data);
        this.sensor_timestamp(sensor_timestamp);
        return this;
    }

    public SDL_GamepadSensorEvent set(SDL_GamepadSensorEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GamepadSensorEvent malloc() {
        return new SDL_GamepadSensorEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GamepadSensorEvent calloc() {
        return new SDL_GamepadSensorEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GamepadSensorEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GamepadSensorEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GamepadSensorEvent create(long address) {
        return new SDL_GamepadSensorEvent(address, null);
    }

    public static @Nullable SDL_GamepadSensorEvent createSafe(long address) {
        return address == 0L ? null : new SDL_GamepadSensorEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GamepadSensorEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GamepadSensorEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GamepadSensorEvent malloc(MemoryStack stack) {
        return new SDL_GamepadSensorEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GamepadSensorEvent calloc(MemoryStack stack) {
        return new SDL_GamepadSensorEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwhich(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WHICH);
    }

    public static int nsensor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SENSOR);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)DATA, 3);
    }

    public static float ndata(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)DATA + Checks.check(index, 3) * 4L);
    }

    public static long nsensor_timestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SENSOR_TIMESTAMP);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwhich(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WHICH, value);
    }

    public static void nsensor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SENSOR, value);
    }

    public static void ndata(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining() * 4);
    }

    public static void ndata(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)DATA + Checks.check(index, 3) * 4L, value);
    }

    public static void nsensor_timestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SENSOR_TIMESTAMP, value);
    }

    static {
        Struct.Layout layout = SDL_GamepadSensorEvent.__struct(SDL_GamepadSensorEvent.__member(4), SDL_GamepadSensorEvent.__member(4), SDL_GamepadSensorEvent.__member(8), SDL_GamepadSensorEvent.__member(4), SDL_GamepadSensorEvent.__member(4), SDL_GamepadSensorEvent.__array(4, 3), SDL_GamepadSensorEvent.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WHICH = layout.offsetof(3);
        SENSOR = layout.offsetof(4);
        DATA = layout.offsetof(5);
        SENSOR_TIMESTAMP = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_GamepadSensorEvent, Buffer>
    implements NativeResource {
        private static final SDL_GamepadSensorEvent ELEMENT_FACTORY = SDL_GamepadSensorEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GamepadSensorEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_GamepadSensorEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_GamepadSensorEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_JoystickID")
        public int which() {
            return SDL_GamepadSensorEvent.nwhich(this.address());
        }

        @NativeType(value="Sint32")
        public int sensor() {
            return SDL_GamepadSensorEvent.nsensor(this.address());
        }

        @NativeType(value="float[3]")
        public FloatBuffer data() {
            return SDL_GamepadSensorEvent.ndata(this.address());
        }

        public float data(int index) {
            return SDL_GamepadSensorEvent.ndata(this.address(), index);
        }

        @NativeType(value="Uint64")
        public long sensor_timestamp() {
            return SDL_GamepadSensorEvent.nsensor_timestamp(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_GamepadSensorEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_GamepadSensorEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer which(@NativeType(value="SDL_JoystickID") int value) {
            SDL_GamepadSensorEvent.nwhich(this.address(), value);
            return this;
        }

        public Buffer sensor(@NativeType(value="Sint32") int value) {
            SDL_GamepadSensorEvent.nsensor(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="float[3]") FloatBuffer value) {
            SDL_GamepadSensorEvent.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, float value) {
            SDL_GamepadSensorEvent.ndata(this.address(), index, value);
            return this;
        }

        public Buffer sensor_timestamp(@NativeType(value="Uint64") long value) {
            SDL_GamepadSensorEvent.nsensor_timestamp(this.address(), value);
            return this;
        }
    }
}

