/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GUID
extends Struct<SDL_GUID>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;

    protected SDL_GUID(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GUID create(long address, @Nullable ByteBuffer container) {
        return new SDL_GUID(address, container);
    }

    public SDL_GUID(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GUID.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint8[16]")
    public ByteBuffer data() {
        return SDL_GUID.ndata(this.address());
    }

    @NativeType(value="Uint8")
    public byte data(int index) {
        return SDL_GUID.ndata(this.address(), index);
    }

    public SDL_GUID data(@NativeType(value="Uint8[16]") ByteBuffer value) {
        SDL_GUID.ndata(this.address(), value);
        return this;
    }

    public SDL_GUID data(int index, @NativeType(value="Uint8") byte value) {
        SDL_GUID.ndata(this.address(), index, value);
        return this;
    }

    public SDL_GUID set(SDL_GUID src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GUID malloc() {
        return new SDL_GUID(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GUID calloc() {
        return new SDL_GUID(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GUID create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GUID(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GUID create(long address) {
        return new SDL_GUID(address, null);
    }

    public static @Nullable SDL_GUID createSafe(long address) {
        return address == 0L ? null : new SDL_GUID(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GUID.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GUID.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GUID malloc(MemoryStack stack) {
        return new SDL_GUID(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GUID calloc(MemoryStack stack) {
        return new SDL_GUID(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, 16);
    }

    public static byte ndata(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DATA + Checks.check(index, 16) * 1L);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining() * 1);
    }

    public static void ndata(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)DATA + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = SDL_GUID.__struct(SDL_GUID.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<SDL_GUID, Buffer>
    implements NativeResource {
        private static final SDL_GUID ELEMENT_FACTORY = SDL_GUID.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GUID getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint8[16]")
        public ByteBuffer data() {
            return SDL_GUID.ndata(this.address());
        }

        @NativeType(value="Uint8")
        public byte data(int index) {
            return SDL_GUID.ndata(this.address(), index);
        }

        public Buffer data(@NativeType(value="Uint8[16]") ByteBuffer value) {
            SDL_GUID.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, @NativeType(value="Uint8") byte value) {
            SDL_GUID.ndata(this.address(), index, value);
            return this;
        }
    }
}

