/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_GPUVertexAttribute;
import org.lwjgl.sdl.SDL_GPUVertexBufferDescription;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUVertexInputState
extends Struct<SDL_GPUVertexInputState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEX_BUFFER_DESCRIPTIONS;
    public static final int NUM_VERTEX_BUFFERS;
    public static final int VERTEX_ATTRIBUTES;
    public static final int NUM_VERTEX_ATTRIBUTES;

    protected SDL_GPUVertexInputState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUVertexInputState create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUVertexInputState(address, container);
    }

    public SDL_GPUVertexInputState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUVertexInputState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUVertexBufferDescription const *")
    public @Nullable SDL_GPUVertexBufferDescription.Buffer vertex_buffer_descriptions() {
        return SDL_GPUVertexInputState.nvertex_buffer_descriptions(this.address());
    }

    @NativeType(value="Uint32")
    public int num_vertex_buffers() {
        return SDL_GPUVertexInputState.nnum_vertex_buffers(this.address());
    }

    @NativeType(value="SDL_GPUVertexAttribute const *")
    public @Nullable SDL_GPUVertexAttribute.Buffer vertex_attributes() {
        return SDL_GPUVertexInputState.nvertex_attributes(this.address());
    }

    @NativeType(value="Uint32")
    public int num_vertex_attributes() {
        return SDL_GPUVertexInputState.nnum_vertex_attributes(this.address());
    }

    public SDL_GPUVertexInputState vertex_buffer_descriptions(@NativeType(value="SDL_GPUVertexBufferDescription const *") @Nullable SDL_GPUVertexBufferDescription.Buffer value) {
        SDL_GPUVertexInputState.nvertex_buffer_descriptions(this.address(), value);
        return this;
    }

    public SDL_GPUVertexInputState num_vertex_buffers(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexInputState.nnum_vertex_buffers(this.address(), value);
        return this;
    }

    public SDL_GPUVertexInputState vertex_attributes(@NativeType(value="SDL_GPUVertexAttribute const *") @Nullable SDL_GPUVertexAttribute.Buffer value) {
        SDL_GPUVertexInputState.nvertex_attributes(this.address(), value);
        return this;
    }

    public SDL_GPUVertexInputState num_vertex_attributes(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexInputState.nnum_vertex_attributes(this.address(), value);
        return this;
    }

    public SDL_GPUVertexInputState set(@Nullable SDL_GPUVertexBufferDescription.Buffer vertex_buffer_descriptions, int num_vertex_buffers, @Nullable SDL_GPUVertexAttribute.Buffer vertex_attributes, int num_vertex_attributes) {
        this.vertex_buffer_descriptions(vertex_buffer_descriptions);
        this.num_vertex_buffers(num_vertex_buffers);
        this.vertex_attributes(vertex_attributes);
        this.num_vertex_attributes(num_vertex_attributes);
        return this;
    }

    public SDL_GPUVertexInputState set(SDL_GPUVertexInputState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUVertexInputState malloc() {
        return new SDL_GPUVertexInputState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUVertexInputState calloc() {
        return new SDL_GPUVertexInputState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUVertexInputState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUVertexInputState(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUVertexInputState create(long address) {
        return new SDL_GPUVertexInputState(address, null);
    }

    public static @Nullable SDL_GPUVertexInputState createSafe(long address) {
        return address == 0L ? null : new SDL_GPUVertexInputState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUVertexInputState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUVertexInputState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUVertexInputState malloc(MemoryStack stack) {
        return new SDL_GPUVertexInputState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUVertexInputState calloc(MemoryStack stack) {
        return new SDL_GPUVertexInputState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable SDL_GPUVertexBufferDescription.Buffer nvertex_buffer_descriptions(long struct) {
        return SDL_GPUVertexBufferDescription.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEX_BUFFER_DESCRIPTIONS), SDL_GPUVertexInputState.nnum_vertex_buffers(struct));
    }

    public static int nnum_vertex_buffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_VERTEX_BUFFERS);
    }

    public static @Nullable SDL_GPUVertexAttribute.Buffer nvertex_attributes(long struct) {
        return SDL_GPUVertexAttribute.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEX_ATTRIBUTES), SDL_GPUVertexInputState.nnum_vertex_attributes(struct));
    }

    public static int nnum_vertex_attributes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_VERTEX_ATTRIBUTES);
    }

    public static void nvertex_buffer_descriptions(long struct, @Nullable SDL_GPUVertexBufferDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_BUFFER_DESCRIPTIONS, MemoryUtil.memAddressSafe(value));
        SDL_GPUVertexInputState.nnum_vertex_buffers(struct, value == null ? 0 : value.remaining());
    }

    public static void nnum_vertex_buffers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_VERTEX_BUFFERS, value);
    }

    public static void nvertex_attributes(long struct, @Nullable SDL_GPUVertexAttribute.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_ATTRIBUTES, MemoryUtil.memAddressSafe(value));
        SDL_GPUVertexInputState.nnum_vertex_attributes(struct, value == null ? 0 : value.remaining());
    }

    public static void nnum_vertex_attributes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_VERTEX_ATTRIBUTES, value);
    }

    static {
        Struct.Layout layout = SDL_GPUVertexInputState.__struct(SDL_GPUVertexInputState.__member(POINTER_SIZE), SDL_GPUVertexInputState.__member(4), SDL_GPUVertexInputState.__member(POINTER_SIZE), SDL_GPUVertexInputState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEX_BUFFER_DESCRIPTIONS = layout.offsetof(0);
        NUM_VERTEX_BUFFERS = layout.offsetof(1);
        VERTEX_ATTRIBUTES = layout.offsetof(2);
        NUM_VERTEX_ATTRIBUTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUVertexInputState, Buffer>
    implements NativeResource {
        private static final SDL_GPUVertexInputState ELEMENT_FACTORY = SDL_GPUVertexInputState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUVertexInputState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUVertexBufferDescription const *")
        public @Nullable SDL_GPUVertexBufferDescription.Buffer vertex_buffer_descriptions() {
            return SDL_GPUVertexInputState.nvertex_buffer_descriptions(this.address());
        }

        @NativeType(value="Uint32")
        public int num_vertex_buffers() {
            return SDL_GPUVertexInputState.nnum_vertex_buffers(this.address());
        }

        @NativeType(value="SDL_GPUVertexAttribute const *")
        public @Nullable SDL_GPUVertexAttribute.Buffer vertex_attributes() {
            return SDL_GPUVertexInputState.nvertex_attributes(this.address());
        }

        @NativeType(value="Uint32")
        public int num_vertex_attributes() {
            return SDL_GPUVertexInputState.nnum_vertex_attributes(this.address());
        }

        public Buffer vertex_buffer_descriptions(@NativeType(value="SDL_GPUVertexBufferDescription const *") @Nullable SDL_GPUVertexBufferDescription.Buffer value) {
            SDL_GPUVertexInputState.nvertex_buffer_descriptions(this.address(), value);
            return this;
        }

        public Buffer num_vertex_buffers(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexInputState.nnum_vertex_buffers(this.address(), value);
            return this;
        }

        public Buffer vertex_attributes(@NativeType(value="SDL_GPUVertexAttribute const *") @Nullable SDL_GPUVertexAttribute.Buffer value) {
            SDL_GPUVertexInputState.nvertex_attributes(this.address(), value);
            return this;
        }

        public Buffer num_vertex_attributes(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexInputState.nnum_vertex_attributes(this.address(), value);
            return this;
        }
    }
}

