/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUTextureSamplerBinding
extends Struct<SDL_GPUTextureSamplerBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int SAMPLER;

    protected SDL_GPUTextureSamplerBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUTextureSamplerBinding create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUTextureSamplerBinding(address, container);
    }

    public SDL_GPUTextureSamplerBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUTextureSamplerBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUTextureSamplerBinding.ntexture(this.address());
    }

    @NativeType(value="SDL_GPUSampler *")
    public long sampler() {
        return SDL_GPUTextureSamplerBinding.nsampler(this.address());
    }

    public SDL_GPUTextureSamplerBinding texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUTextureSamplerBinding.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUTextureSamplerBinding sampler(@NativeType(value="SDL_GPUSampler *") long value) {
        SDL_GPUTextureSamplerBinding.nsampler(this.address(), value);
        return this;
    }

    public SDL_GPUTextureSamplerBinding set(long texture, long sampler) {
        this.texture(texture);
        this.sampler(sampler);
        return this;
    }

    public SDL_GPUTextureSamplerBinding set(SDL_GPUTextureSamplerBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUTextureSamplerBinding malloc() {
        return new SDL_GPUTextureSamplerBinding(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUTextureSamplerBinding calloc() {
        return new SDL_GPUTextureSamplerBinding(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUTextureSamplerBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUTextureSamplerBinding(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUTextureSamplerBinding create(long address) {
        return new SDL_GPUTextureSamplerBinding(address, null);
    }

    public static @Nullable SDL_GPUTextureSamplerBinding createSafe(long address) {
        return address == 0L ? null : new SDL_GPUTextureSamplerBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUTextureSamplerBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUTextureSamplerBinding.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUTextureSamplerBinding malloc(MemoryStack stack) {
        return new SDL_GPUTextureSamplerBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUTextureSamplerBinding calloc(MemoryStack stack) {
        return new SDL_GPUTextureSamplerBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TEXTURE);
    }

    public static long nsampler(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SAMPLER);
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TEXTURE, Checks.check(value));
    }

    public static void nsampler(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SAMPLER, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TEXTURE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SAMPLER));
    }

    static {
        Struct.Layout layout = SDL_GPUTextureSamplerBinding.__struct(SDL_GPUTextureSamplerBinding.__member(POINTER_SIZE), SDL_GPUTextureSamplerBinding.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        SAMPLER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUTextureSamplerBinding, Buffer>
    implements NativeResource {
        private static final SDL_GPUTextureSamplerBinding ELEMENT_FACTORY = SDL_GPUTextureSamplerBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUTextureSamplerBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUTextureSamplerBinding.ntexture(this.address());
        }

        @NativeType(value="SDL_GPUSampler *")
        public long sampler() {
            return SDL_GPUTextureSamplerBinding.nsampler(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUTextureSamplerBinding.ntexture(this.address(), value);
            return this;
        }

        public Buffer sampler(@NativeType(value="SDL_GPUSampler *") long value) {
            SDL_GPUTextureSamplerBinding.nsampler(this.address(), value);
            return this;
        }
    }
}

