/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUStencilOpState
extends Struct<SDL_GPUStencilOpState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FAIL_OP;
    public static final int PASS_OP;
    public static final int DEPTH_FAIL_OP;
    public static final int COMPARE_OP;

    protected SDL_GPUStencilOpState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUStencilOpState create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUStencilOpState(address, container);
    }

    public SDL_GPUStencilOpState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUStencilOpState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUStencilOp")
    public int fail_op() {
        return SDL_GPUStencilOpState.nfail_op(this.address());
    }

    @NativeType(value="SDL_GPUStencilOp")
    public int pass_op() {
        return SDL_GPUStencilOpState.npass_op(this.address());
    }

    @NativeType(value="SDL_GPUStencilOp")
    public int depth_fail_op() {
        return SDL_GPUStencilOpState.ndepth_fail_op(this.address());
    }

    @NativeType(value="SDL_GPUCompareOp")
    public int compare_op() {
        return SDL_GPUStencilOpState.ncompare_op(this.address());
    }

    public SDL_GPUStencilOpState fail_op(@NativeType(value="SDL_GPUStencilOp") int value) {
        SDL_GPUStencilOpState.nfail_op(this.address(), value);
        return this;
    }

    public SDL_GPUStencilOpState pass_op(@NativeType(value="SDL_GPUStencilOp") int value) {
        SDL_GPUStencilOpState.npass_op(this.address(), value);
        return this;
    }

    public SDL_GPUStencilOpState depth_fail_op(@NativeType(value="SDL_GPUStencilOp") int value) {
        SDL_GPUStencilOpState.ndepth_fail_op(this.address(), value);
        return this;
    }

    public SDL_GPUStencilOpState compare_op(@NativeType(value="SDL_GPUCompareOp") int value) {
        SDL_GPUStencilOpState.ncompare_op(this.address(), value);
        return this;
    }

    public SDL_GPUStencilOpState set(int fail_op, int pass_op, int depth_fail_op, int compare_op) {
        this.fail_op(fail_op);
        this.pass_op(pass_op);
        this.depth_fail_op(depth_fail_op);
        this.compare_op(compare_op);
        return this;
    }

    public SDL_GPUStencilOpState set(SDL_GPUStencilOpState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUStencilOpState malloc() {
        return new SDL_GPUStencilOpState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUStencilOpState calloc() {
        return new SDL_GPUStencilOpState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUStencilOpState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUStencilOpState(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUStencilOpState create(long address) {
        return new SDL_GPUStencilOpState(address, null);
    }

    public static @Nullable SDL_GPUStencilOpState createSafe(long address) {
        return address == 0L ? null : new SDL_GPUStencilOpState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUStencilOpState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUStencilOpState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUStencilOpState malloc(MemoryStack stack) {
        return new SDL_GPUStencilOpState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUStencilOpState calloc(MemoryStack stack) {
        return new SDL_GPUStencilOpState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfail_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FAIL_OP);
    }

    public static int npass_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PASS_OP);
    }

    public static int ndepth_fail_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH_FAIL_OP);
    }

    public static int ncompare_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPARE_OP);
    }

    public static void nfail_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FAIL_OP, value);
    }

    public static void npass_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PASS_OP, value);
    }

    public static void ndepth_fail_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH_FAIL_OP, value);
    }

    public static void ncompare_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPARE_OP, value);
    }

    static {
        Struct.Layout layout = SDL_GPUStencilOpState.__struct(SDL_GPUStencilOpState.__member(4), SDL_GPUStencilOpState.__member(4), SDL_GPUStencilOpState.__member(4), SDL_GPUStencilOpState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FAIL_OP = layout.offsetof(0);
        PASS_OP = layout.offsetof(1);
        DEPTH_FAIL_OP = layout.offsetof(2);
        COMPARE_OP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUStencilOpState, Buffer>
    implements NativeResource {
        private static final SDL_GPUStencilOpState ELEMENT_FACTORY = SDL_GPUStencilOpState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUStencilOpState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUStencilOp")
        public int fail_op() {
            return SDL_GPUStencilOpState.nfail_op(this.address());
        }

        @NativeType(value="SDL_GPUStencilOp")
        public int pass_op() {
            return SDL_GPUStencilOpState.npass_op(this.address());
        }

        @NativeType(value="SDL_GPUStencilOp")
        public int depth_fail_op() {
            return SDL_GPUStencilOpState.ndepth_fail_op(this.address());
        }

        @NativeType(value="SDL_GPUCompareOp")
        public int compare_op() {
            return SDL_GPUStencilOpState.ncompare_op(this.address());
        }

        public Buffer fail_op(@NativeType(value="SDL_GPUStencilOp") int value) {
            SDL_GPUStencilOpState.nfail_op(this.address(), value);
            return this;
        }

        public Buffer pass_op(@NativeType(value="SDL_GPUStencilOp") int value) {
            SDL_GPUStencilOpState.npass_op(this.address(), value);
            return this;
        }

        public Buffer depth_fail_op(@NativeType(value="SDL_GPUStencilOp") int value) {
            SDL_GPUStencilOpState.ndepth_fail_op(this.address(), value);
            return this;
        }

        public Buffer compare_op(@NativeType(value="SDL_GPUCompareOp") int value) {
            SDL_GPUStencilOpState.ncompare_op(this.address(), value);
            return this;
        }
    }
}

