/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_FColor;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUColorTargetInfo
extends Struct<SDL_GPUColorTargetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int MIP_LEVEL;
    public static final int LAYER_OR_DEPTH_PLANE;
    public static final int CLEAR_COLOR;
    public static final int LOAD_OP;
    public static final int STORE_OP;
    public static final int RESOLVE_TEXTURE;
    public static final int RESOLVE_MIP_LEVEL;
    public static final int RESOLVE_LAYER;
    public static final int CYCLE;
    public static final int CYCLE_RESOLVE_TEXTURE;
    public static final int PADDING1;
    public static final int PADDING2;

    protected SDL_GPUColorTargetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUColorTargetInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUColorTargetInfo(address, container);
    }

    public SDL_GPUColorTargetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUColorTargetInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUColorTargetInfo.ntexture(this.address());
    }

    @NativeType(value="Uint32")
    public int mip_level() {
        return SDL_GPUColorTargetInfo.nmip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int layer_or_depth_plane() {
        return SDL_GPUColorTargetInfo.nlayer_or_depth_plane(this.address());
    }

    public SDL_FColor clear_color() {
        return SDL_GPUColorTargetInfo.nclear_color(this.address());
    }

    @NativeType(value="SDL_GPULoadOp")
    public int load_op() {
        return SDL_GPUColorTargetInfo.nload_op(this.address());
    }

    @NativeType(value="SDL_GPUStoreOp")
    public int store_op() {
        return SDL_GPUColorTargetInfo.nstore_op(this.address());
    }

    @NativeType(value="SDL_GPUTexture *")
    public long resolve_texture() {
        return SDL_GPUColorTargetInfo.nresolve_texture(this.address());
    }

    @NativeType(value="Uint32")
    public int resolve_mip_level() {
        return SDL_GPUColorTargetInfo.nresolve_mip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int resolve_layer() {
        return SDL_GPUColorTargetInfo.nresolve_layer(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle() {
        return SDL_GPUColorTargetInfo.ncycle(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle_resolve_texture() {
        return SDL_GPUColorTargetInfo.ncycle_resolve_texture(this.address());
    }

    public SDL_GPUColorTargetInfo texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUColorTargetInfo.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUColorTargetInfo.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo layer_or_depth_plane(@NativeType(value="Uint32") int value) {
        SDL_GPUColorTargetInfo.nlayer_or_depth_plane(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo clear_color(SDL_FColor value) {
        SDL_GPUColorTargetInfo.nclear_color(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo clear_color(Consumer<SDL_FColor> consumer) {
        consumer.accept(this.clear_color());
        return this;
    }

    public SDL_GPUColorTargetInfo load_op(@NativeType(value="SDL_GPULoadOp") int value) {
        SDL_GPUColorTargetInfo.nload_op(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
        SDL_GPUColorTargetInfo.nstore_op(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo resolve_texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUColorTargetInfo.nresolve_texture(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo resolve_mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUColorTargetInfo.nresolve_mip_level(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo resolve_layer(@NativeType(value="Uint32") int value) {
        SDL_GPUColorTargetInfo.nresolve_layer(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo cycle(@NativeType(value="bool") boolean value) {
        SDL_GPUColorTargetInfo.ncycle(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo cycle_resolve_texture(@NativeType(value="bool") boolean value) {
        SDL_GPUColorTargetInfo.ncycle_resolve_texture(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetInfo set(long texture, int mip_level, int layer_or_depth_plane, SDL_FColor clear_color, int load_op, int store_op, long resolve_texture, int resolve_mip_level, int resolve_layer, boolean cycle, boolean cycle_resolve_texture) {
        this.texture(texture);
        this.mip_level(mip_level);
        this.layer_or_depth_plane(layer_or_depth_plane);
        this.clear_color(clear_color);
        this.load_op(load_op);
        this.store_op(store_op);
        this.resolve_texture(resolve_texture);
        this.resolve_mip_level(resolve_mip_level);
        this.resolve_layer(resolve_layer);
        this.cycle(cycle);
        this.cycle_resolve_texture(cycle_resolve_texture);
        return this;
    }

    public SDL_GPUColorTargetInfo set(SDL_GPUColorTargetInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUColorTargetInfo malloc() {
        return new SDL_GPUColorTargetInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUColorTargetInfo calloc() {
        return new SDL_GPUColorTargetInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUColorTargetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUColorTargetInfo(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUColorTargetInfo create(long address) {
        return new SDL_GPUColorTargetInfo(address, null);
    }

    public static @Nullable SDL_GPUColorTargetInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUColorTargetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUColorTargetInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUColorTargetInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUColorTargetInfo malloc(MemoryStack stack) {
        return new SDL_GPUColorTargetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUColorTargetInfo calloc(MemoryStack stack) {
        return new SDL_GPUColorTargetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TEXTURE);
    }

    public static int nmip_level(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIP_LEVEL);
    }

    public static int nlayer_or_depth_plane(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER_OR_DEPTH_PLANE);
    }

    public static SDL_FColor nclear_color(long struct) {
        return SDL_FColor.create(struct + (long)CLEAR_COLOR);
    }

    public static int nload_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOAD_OP);
    }

    public static int nstore_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STORE_OP);
    }

    public static long nresolve_texture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RESOLVE_TEXTURE);
    }

    public static int nresolve_mip_level(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESOLVE_MIP_LEVEL);
    }

    public static int nresolve_layer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESOLVE_LAYER);
    }

    public static boolean ncycle(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CYCLE) != 0;
    }

    public static boolean ncycle_resolve_texture(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CYCLE_RESOLVE_TEXTURE) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TEXTURE, Checks.check(value));
    }

    public static void nmip_level(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIP_LEVEL, value);
    }

    public static void nlayer_or_depth_plane(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER_OR_DEPTH_PLANE, value);
    }

    public static void nclear_color(long struct, SDL_FColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CLEAR_COLOR, SDL_FColor.SIZEOF);
    }

    public static void nload_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOAD_OP, value);
    }

    public static void nstore_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STORE_OP, value);
    }

    public static void nresolve_texture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RESOLVE_TEXTURE, value);
    }

    public static void nresolve_mip_level(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESOLVE_MIP_LEVEL, value);
    }

    public static void nresolve_layer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESOLVE_LAYER, value);
    }

    public static void ncycle(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CYCLE, value ? (byte)1 : 0);
    }

    public static void ncycle_resolve_texture(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CYCLE_RESOLVE_TEXTURE, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TEXTURE));
    }

    static {
        Struct.Layout layout = SDL_GPUColorTargetInfo.__struct(SDL_GPUColorTargetInfo.__member(POINTER_SIZE), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(SDL_FColor.SIZEOF, SDL_FColor.ALIGNOF), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(POINTER_SIZE), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(4), SDL_GPUColorTargetInfo.__member(1), SDL_GPUColorTargetInfo.__member(1), SDL_GPUColorTargetInfo.__member(1), SDL_GPUColorTargetInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        MIP_LEVEL = layout.offsetof(1);
        LAYER_OR_DEPTH_PLANE = layout.offsetof(2);
        CLEAR_COLOR = layout.offsetof(3);
        LOAD_OP = layout.offsetof(4);
        STORE_OP = layout.offsetof(5);
        RESOLVE_TEXTURE = layout.offsetof(6);
        RESOLVE_MIP_LEVEL = layout.offsetof(7);
        RESOLVE_LAYER = layout.offsetof(8);
        CYCLE = layout.offsetof(9);
        CYCLE_RESOLVE_TEXTURE = layout.offsetof(10);
        PADDING1 = layout.offsetof(11);
        PADDING2 = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUColorTargetInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUColorTargetInfo ELEMENT_FACTORY = SDL_GPUColorTargetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUColorTargetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUColorTargetInfo.ntexture(this.address());
        }

        @NativeType(value="Uint32")
        public int mip_level() {
            return SDL_GPUColorTargetInfo.nmip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int layer_or_depth_plane() {
            return SDL_GPUColorTargetInfo.nlayer_or_depth_plane(this.address());
        }

        public SDL_FColor clear_color() {
            return SDL_GPUColorTargetInfo.nclear_color(this.address());
        }

        @NativeType(value="SDL_GPULoadOp")
        public int load_op() {
            return SDL_GPUColorTargetInfo.nload_op(this.address());
        }

        @NativeType(value="SDL_GPUStoreOp")
        public int store_op() {
            return SDL_GPUColorTargetInfo.nstore_op(this.address());
        }

        @NativeType(value="SDL_GPUTexture *")
        public long resolve_texture() {
            return SDL_GPUColorTargetInfo.nresolve_texture(this.address());
        }

        @NativeType(value="Uint32")
        public int resolve_mip_level() {
            return SDL_GPUColorTargetInfo.nresolve_mip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int resolve_layer() {
            return SDL_GPUColorTargetInfo.nresolve_layer(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle() {
            return SDL_GPUColorTargetInfo.ncycle(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle_resolve_texture() {
            return SDL_GPUColorTargetInfo.ncycle_resolve_texture(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUColorTargetInfo.ntexture(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUColorTargetInfo.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer_or_depth_plane(@NativeType(value="Uint32") int value) {
            SDL_GPUColorTargetInfo.nlayer_or_depth_plane(this.address(), value);
            return this;
        }

        public Buffer clear_color(SDL_FColor value) {
            SDL_GPUColorTargetInfo.nclear_color(this.address(), value);
            return this;
        }

        public Buffer clear_color(Consumer<SDL_FColor> consumer) {
            consumer.accept(this.clear_color());
            return this;
        }

        public Buffer load_op(@NativeType(value="SDL_GPULoadOp") int value) {
            SDL_GPUColorTargetInfo.nload_op(this.address(), value);
            return this;
        }

        public Buffer store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
            SDL_GPUColorTargetInfo.nstore_op(this.address(), value);
            return this;
        }

        public Buffer resolve_texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUColorTargetInfo.nresolve_texture(this.address(), value);
            return this;
        }

        public Buffer resolve_mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUColorTargetInfo.nresolve_mip_level(this.address(), value);
            return this;
        }

        public Buffer resolve_layer(@NativeType(value="Uint32") int value) {
            SDL_GPUColorTargetInfo.nresolve_layer(this.address(), value);
            return this;
        }

        public Buffer cycle(@NativeType(value="bool") boolean value) {
            SDL_GPUColorTargetInfo.ncycle(this.address(), value);
            return this;
        }

        public Buffer cycle_resolve_texture(@NativeType(value="bool") boolean value) {
            SDL_GPUColorTargetInfo.ncycle_resolve_texture(this.address(), value);
            return this;
        }
    }
}

