/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUBlitRegion
extends Struct<SDL_GPUBlitRegion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int MIP_LEVEL;
    public static final int LAYER_OR_DEPTH_PLANE;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    protected SDL_GPUBlitRegion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUBlitRegion create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUBlitRegion(address, container);
    }

    public SDL_GPUBlitRegion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUBlitRegion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUBlitRegion.ntexture(this.address());
    }

    @NativeType(value="Uint32")
    public int mip_level() {
        return SDL_GPUBlitRegion.nmip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int layer_or_depth_plane() {
        return SDL_GPUBlitRegion.nlayer_or_depth_plane(this.address());
    }

    @NativeType(value="Uint32")
    public int x() {
        return SDL_GPUBlitRegion.nx(this.address());
    }

    @NativeType(value="Uint32")
    public int y() {
        return SDL_GPUBlitRegion.ny(this.address());
    }

    @NativeType(value="Uint32")
    public int w() {
        return SDL_GPUBlitRegion.nw(this.address());
    }

    @NativeType(value="Uint32")
    public int h() {
        return SDL_GPUBlitRegion.nh(this.address());
    }

    public SDL_GPUBlitRegion texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUBlitRegion.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion layer_or_depth_plane(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.nlayer_or_depth_plane(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion x(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.nx(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion y(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.ny(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion w(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.nw(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion h(@NativeType(value="Uint32") int value) {
        SDL_GPUBlitRegion.nh(this.address(), value);
        return this;
    }

    public SDL_GPUBlitRegion set(long texture, int mip_level, int layer_or_depth_plane, int x, int y, int w, int h) {
        this.texture(texture);
        this.mip_level(mip_level);
        this.layer_or_depth_plane(layer_or_depth_plane);
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public SDL_GPUBlitRegion set(SDL_GPUBlitRegion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUBlitRegion malloc() {
        return new SDL_GPUBlitRegion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUBlitRegion calloc() {
        return new SDL_GPUBlitRegion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUBlitRegion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUBlitRegion(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUBlitRegion create(long address) {
        return new SDL_GPUBlitRegion(address, null);
    }

    public static @Nullable SDL_GPUBlitRegion createSafe(long address) {
        return address == 0L ? null : new SDL_GPUBlitRegion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUBlitRegion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUBlitRegion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUBlitRegion malloc(MemoryStack stack) {
        return new SDL_GPUBlitRegion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUBlitRegion calloc(MemoryStack stack) {
        return new SDL_GPUBlitRegion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TEXTURE);
    }

    public static int nmip_level(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIP_LEVEL);
    }

    public static int nlayer_or_depth_plane(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER_OR_DEPTH_PLANE);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TEXTURE, Checks.check(value));
    }

    public static void nmip_level(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIP_LEVEL, value);
    }

    public static void nlayer_or_depth_plane(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER_OR_DEPTH_PLANE, value);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TEXTURE));
    }

    static {
        Struct.Layout layout = SDL_GPUBlitRegion.__struct(SDL_GPUBlitRegion.__member(POINTER_SIZE), SDL_GPUBlitRegion.__member(4), SDL_GPUBlitRegion.__member(4), SDL_GPUBlitRegion.__member(4), SDL_GPUBlitRegion.__member(4), SDL_GPUBlitRegion.__member(4), SDL_GPUBlitRegion.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        MIP_LEVEL = layout.offsetof(1);
        LAYER_OR_DEPTH_PLANE = layout.offsetof(2);
        X = layout.offsetof(3);
        Y = layout.offsetof(4);
        W = layout.offsetof(5);
        H = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUBlitRegion, Buffer>
    implements NativeResource {
        private static final SDL_GPUBlitRegion ELEMENT_FACTORY = SDL_GPUBlitRegion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUBlitRegion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUBlitRegion.ntexture(this.address());
        }

        @NativeType(value="Uint32")
        public int mip_level() {
            return SDL_GPUBlitRegion.nmip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int layer_or_depth_plane() {
            return SDL_GPUBlitRegion.nlayer_or_depth_plane(this.address());
        }

        @NativeType(value="Uint32")
        public int x() {
            return SDL_GPUBlitRegion.nx(this.address());
        }

        @NativeType(value="Uint32")
        public int y() {
            return SDL_GPUBlitRegion.ny(this.address());
        }

        @NativeType(value="Uint32")
        public int w() {
            return SDL_GPUBlitRegion.nw(this.address());
        }

        @NativeType(value="Uint32")
        public int h() {
            return SDL_GPUBlitRegion.nh(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUBlitRegion.ntexture(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer_or_depth_plane(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.nlayer_or_depth_plane(this.address(), value);
            return this;
        }

        public Buffer x(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.ny(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="Uint32") int value) {
            SDL_GPUBlitRegion.nh(this.address(), value);
            return this;
        }
    }
}

