/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Finger
extends Struct<SDL_Finger>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int X;
    public static final int Y;
    public static final int PRESSURE;

    protected SDL_Finger(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Finger create(long address, @Nullable ByteBuffer container) {
        return new SDL_Finger(address, container);
    }

    public SDL_Finger(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Finger.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_FingerID")
    public long id() {
        return SDL_Finger.nid(this.address());
    }

    public float x() {
        return SDL_Finger.nx(this.address());
    }

    public float y() {
        return SDL_Finger.ny(this.address());
    }

    public float pressure() {
        return SDL_Finger.npressure(this.address());
    }

    public SDL_Finger id(@NativeType(value="SDL_FingerID") long value) {
        SDL_Finger.nid(this.address(), value);
        return this;
    }

    public SDL_Finger x(float value) {
        SDL_Finger.nx(this.address(), value);
        return this;
    }

    public SDL_Finger y(float value) {
        SDL_Finger.ny(this.address(), value);
        return this;
    }

    public SDL_Finger pressure(float value) {
        SDL_Finger.npressure(this.address(), value);
        return this;
    }

    public SDL_Finger set(long id, float x, float y, float pressure) {
        this.id(id);
        this.x(x);
        this.y(y);
        this.pressure(pressure);
        return this;
    }

    public SDL_Finger set(SDL_Finger src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_Finger malloc() {
        return new SDL_Finger(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Finger calloc() {
        return new SDL_Finger(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Finger create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Finger(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Finger create(long address) {
        return new SDL_Finger(address, null);
    }

    public static @Nullable SDL_Finger createSafe(long address) {
        return address == 0L ? null : new SDL_Finger(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Finger.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Finger.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Finger malloc(MemoryStack stack) {
        return new SDL_Finger(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Finger calloc(MemoryStack stack) {
        return new SDL_Finger(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nid(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ID);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float npressure(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PRESSURE);
    }

    public static void nid(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ID, value);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void npressure(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)PRESSURE, value);
    }

    static {
        Struct.Layout layout = SDL_Finger.__struct(SDL_Finger.__member(8), SDL_Finger.__member(4), SDL_Finger.__member(4), SDL_Finger.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        PRESSURE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_Finger, Buffer>
    implements NativeResource {
        private static final SDL_Finger ELEMENT_FACTORY = SDL_Finger.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Finger getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_FingerID")
        public long id() {
            return SDL_Finger.nid(this.address());
        }

        public float x() {
            return SDL_Finger.nx(this.address());
        }

        public float y() {
            return SDL_Finger.ny(this.address());
        }

        public float pressure() {
            return SDL_Finger.npressure(this.address());
        }

        public Buffer id(@NativeType(value="SDL_FingerID") long value) {
            SDL_Finger.nid(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            SDL_Finger.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            SDL_Finger.ny(this.address(), value);
            return this;
        }

        public Buffer pressure(float value) {
            SDL_Finger.npressure(this.address(), value);
            return this;
        }
    }
}

