/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_DateTime
extends Struct<SDL_DateTime>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int YEAR;
    public static final int MONTH;
    public static final int DAY;
    public static final int HOUR;
    public static final int MINUTE;
    public static final int SECOND;
    public static final int NANOSECOND;
    public static final int DAY_OF_WEEK;
    public static final int UTC_OFFSET;

    protected SDL_DateTime(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_DateTime create(long address, @Nullable ByteBuffer container) {
        return new SDL_DateTime(address, container);
    }

    public SDL_DateTime(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_DateTime.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int year() {
        return SDL_DateTime.nyear(this.address());
    }

    public int month() {
        return SDL_DateTime.nmonth(this.address());
    }

    public int day() {
        return SDL_DateTime.nday(this.address());
    }

    public int hour() {
        return SDL_DateTime.nhour(this.address());
    }

    public int minute() {
        return SDL_DateTime.nminute(this.address());
    }

    public int second() {
        return SDL_DateTime.nsecond(this.address());
    }

    public int nanosecond() {
        return SDL_DateTime.nnanosecond(this.address());
    }

    public int day_of_week() {
        return SDL_DateTime.nday_of_week(this.address());
    }

    public int utc_offset() {
        return SDL_DateTime.nutc_offset(this.address());
    }

    public SDL_DateTime year(int value) {
        SDL_DateTime.nyear(this.address(), value);
        return this;
    }

    public SDL_DateTime month(int value) {
        SDL_DateTime.nmonth(this.address(), value);
        return this;
    }

    public SDL_DateTime day(int value) {
        SDL_DateTime.nday(this.address(), value);
        return this;
    }

    public SDL_DateTime hour(int value) {
        SDL_DateTime.nhour(this.address(), value);
        return this;
    }

    public SDL_DateTime minute(int value) {
        SDL_DateTime.nminute(this.address(), value);
        return this;
    }

    public SDL_DateTime second(int value) {
        SDL_DateTime.nsecond(this.address(), value);
        return this;
    }

    public SDL_DateTime nanosecond(int value) {
        SDL_DateTime.nnanosecond(this.address(), value);
        return this;
    }

    public SDL_DateTime day_of_week(int value) {
        SDL_DateTime.nday_of_week(this.address(), value);
        return this;
    }

    public SDL_DateTime utc_offset(int value) {
        SDL_DateTime.nutc_offset(this.address(), value);
        return this;
    }

    public SDL_DateTime set(int year, int month, int day, int hour, int minute, int second, int nanosecond, int day_of_week, int utc_offset) {
        this.year(year);
        this.month(month);
        this.day(day);
        this.hour(hour);
        this.minute(minute);
        this.second(second);
        this.nanosecond(nanosecond);
        this.day_of_week(day_of_week);
        this.utc_offset(utc_offset);
        return this;
    }

    public SDL_DateTime set(SDL_DateTime src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_DateTime malloc() {
        return new SDL_DateTime(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_DateTime calloc() {
        return new SDL_DateTime(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_DateTime create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_DateTime(MemoryUtil.memAddress(container), container);
    }

    public static SDL_DateTime create(long address) {
        return new SDL_DateTime(address, null);
    }

    public static @Nullable SDL_DateTime createSafe(long address) {
        return address == 0L ? null : new SDL_DateTime(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_DateTime.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_DateTime.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_DateTime malloc(MemoryStack stack) {
        return new SDL_DateTime(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_DateTime calloc(MemoryStack stack) {
        return new SDL_DateTime(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nyear(long struct) {
        return MemoryUtil.memGetInt(struct + (long)YEAR);
    }

    public static int nmonth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MONTH);
    }

    public static int nday(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DAY);
    }

    public static int nhour(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HOUR);
    }

    public static int nminute(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINUTE);
    }

    public static int nsecond(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SECOND);
    }

    public static int nnanosecond(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NANOSECOND);
    }

    public static int nday_of_week(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DAY_OF_WEEK);
    }

    public static int nutc_offset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UTC_OFFSET);
    }

    public static void nyear(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)YEAR, value);
    }

    public static void nmonth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MONTH, value);
    }

    public static void nday(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DAY, value);
    }

    public static void nhour(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HOUR, value);
    }

    public static void nminute(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINUTE, value);
    }

    public static void nsecond(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SECOND, value);
    }

    public static void nnanosecond(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NANOSECOND, value);
    }

    public static void nday_of_week(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DAY_OF_WEEK, value);
    }

    public static void nutc_offset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UTC_OFFSET, value);
    }

    static {
        Struct.Layout layout = SDL_DateTime.__struct(SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4), SDL_DateTime.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        YEAR = layout.offsetof(0);
        MONTH = layout.offsetof(1);
        DAY = layout.offsetof(2);
        HOUR = layout.offsetof(3);
        MINUTE = layout.offsetof(4);
        SECOND = layout.offsetof(5);
        NANOSECOND = layout.offsetof(6);
        DAY_OF_WEEK = layout.offsetof(7);
        UTC_OFFSET = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<SDL_DateTime, Buffer>
    implements NativeResource {
        private static final SDL_DateTime ELEMENT_FACTORY = SDL_DateTime.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_DateTime getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int year() {
            return SDL_DateTime.nyear(this.address());
        }

        public int month() {
            return SDL_DateTime.nmonth(this.address());
        }

        public int day() {
            return SDL_DateTime.nday(this.address());
        }

        public int hour() {
            return SDL_DateTime.nhour(this.address());
        }

        public int minute() {
            return SDL_DateTime.nminute(this.address());
        }

        public int second() {
            return SDL_DateTime.nsecond(this.address());
        }

        public int nanosecond() {
            return SDL_DateTime.nnanosecond(this.address());
        }

        public int day_of_week() {
            return SDL_DateTime.nday_of_week(this.address());
        }

        public int utc_offset() {
            return SDL_DateTime.nutc_offset(this.address());
        }

        public Buffer year(int value) {
            SDL_DateTime.nyear(this.address(), value);
            return this;
        }

        public Buffer month(int value) {
            SDL_DateTime.nmonth(this.address(), value);
            return this;
        }

        public Buffer day(int value) {
            SDL_DateTime.nday(this.address(), value);
            return this;
        }

        public Buffer hour(int value) {
            SDL_DateTime.nhour(this.address(), value);
            return this;
        }

        public Buffer minute(int value) {
            SDL_DateTime.nminute(this.address(), value);
            return this;
        }

        public Buffer second(int value) {
            SDL_DateTime.nsecond(this.address(), value);
            return this;
        }

        public Buffer nanosecond(int value) {
            SDL_DateTime.nnanosecond(this.address(), value);
            return this;
        }

        public Buffer day_of_week(int value) {
            SDL_DateTime.nday_of_week(this.address(), value);
            return this;
        }

        public Buffer utc_offset(int value) {
            SDL_DateTime.nutc_offset(this.address(), value);
            return this;
        }
    }
}

