/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_ClipboardEvent
extends Struct<SDL_ClipboardEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int OWNER;
    public static final int NUM_MIME_TYPES;
    public static final int MIME_TYPES;

    protected SDL_ClipboardEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_ClipboardEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_ClipboardEvent(address, container);
    }

    public SDL_ClipboardEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_ClipboardEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_ClipboardEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_ClipboardEvent.ntimestamp(this.address());
    }

    @NativeType(value="bool")
    public boolean owner() {
        return SDL_ClipboardEvent.nowner(this.address());
    }

    @NativeType(value="Sint32")
    public int num_mime_types() {
        return SDL_ClipboardEvent.nnum_mime_types(this.address());
    }

    @NativeType(value="char const **")
    public @Nullable PointerBuffer mime_types() {
        return SDL_ClipboardEvent.nmime_types(this.address());
    }

    public SDL_ClipboardEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_ClipboardEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_ClipboardEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_ClipboardEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_ClipboardEvent owner(@NativeType(value="bool") boolean value) {
        SDL_ClipboardEvent.nowner(this.address(), value);
        return this;
    }

    public SDL_ClipboardEvent num_mime_types(@NativeType(value="Sint32") int value) {
        SDL_ClipboardEvent.nnum_mime_types(this.address(), value);
        return this;
    }

    public SDL_ClipboardEvent mime_types(@NativeType(value="char const **") @Nullable PointerBuffer value) {
        SDL_ClipboardEvent.nmime_types(this.address(), value);
        return this;
    }

    public SDL_ClipboardEvent set(int type, long timestamp, boolean owner, int num_mime_types, @Nullable PointerBuffer mime_types) {
        this.type(type);
        this.timestamp(timestamp);
        this.owner(owner);
        this.num_mime_types(num_mime_types);
        this.mime_types(mime_types);
        return this;
    }

    public SDL_ClipboardEvent set(SDL_ClipboardEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_ClipboardEvent malloc() {
        return new SDL_ClipboardEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_ClipboardEvent calloc() {
        return new SDL_ClipboardEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_ClipboardEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_ClipboardEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_ClipboardEvent create(long address) {
        return new SDL_ClipboardEvent(address, null);
    }

    public static @Nullable SDL_ClipboardEvent createSafe(long address) {
        return address == 0L ? null : new SDL_ClipboardEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_ClipboardEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_ClipboardEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_ClipboardEvent malloc(MemoryStack stack) {
        return new SDL_ClipboardEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_ClipboardEvent calloc(MemoryStack stack) {
        return new SDL_ClipboardEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static boolean nowner(long struct) {
        return MemoryUtil.memGetByte(struct + (long)OWNER) != 0;
    }

    public static int nnum_mime_types(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_MIME_TYPES);
    }

    public static @Nullable PointerBuffer nmime_types(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MIME_TYPES), SDL_ClipboardEvent.nnum_mime_types(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nowner(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)OWNER, value ? (byte)1 : 0);
    }

    public static void nnum_mime_types(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_MIME_TYPES, value);
    }

    public static void nmime_types(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MIME_TYPES, MemoryUtil.memAddressSafe(value));
        SDL_ClipboardEvent.nnum_mime_types(struct, value == null ? 0 : value.remaining());
    }

    static {
        Struct.Layout layout = SDL_ClipboardEvent.__struct(SDL_ClipboardEvent.__member(4), SDL_ClipboardEvent.__member(4), SDL_ClipboardEvent.__member(8), SDL_ClipboardEvent.__member(1), SDL_ClipboardEvent.__member(4), SDL_ClipboardEvent.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        OWNER = layout.offsetof(3);
        NUM_MIME_TYPES = layout.offsetof(4);
        MIME_TYPES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_ClipboardEvent, Buffer>
    implements NativeResource {
        private static final SDL_ClipboardEvent ELEMENT_FACTORY = SDL_ClipboardEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_ClipboardEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_ClipboardEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_ClipboardEvent.ntimestamp(this.address());
        }

        @NativeType(value="bool")
        public boolean owner() {
            return SDL_ClipboardEvent.nowner(this.address());
        }

        @NativeType(value="Sint32")
        public int num_mime_types() {
            return SDL_ClipboardEvent.nnum_mime_types(this.address());
        }

        @NativeType(value="char const **")
        public @Nullable PointerBuffer mime_types() {
            return SDL_ClipboardEvent.nmime_types(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_ClipboardEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_ClipboardEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer owner(@NativeType(value="bool") boolean value) {
            SDL_ClipboardEvent.nowner(this.address(), value);
            return this;
        }

        public Buffer num_mime_types(@NativeType(value="Sint32") int value) {
            SDL_ClipboardEvent.nnum_mime_types(this.address(), value);
            return this;
        }

        public Buffer mime_types(@NativeType(value="char const **") @Nullable PointerBuffer value) {
            SDL_ClipboardEvent.nmime_types(this.address(), value);
            return this;
        }
    }
}

