/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_CameraSpec
extends Struct<SDL_CameraSpec>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int COLORSPACE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int FRAMERATE_NUMERATOR;
    public static final int FRAMERATE_DENOMINATOR;

    protected SDL_CameraSpec(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_CameraSpec create(long address, @Nullable ByteBuffer container) {
        return new SDL_CameraSpec(address, container);
    }

    public SDL_CameraSpec(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_CameraSpec.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_PixelFormat")
    public int format() {
        return SDL_CameraSpec.nformat(this.address());
    }

    @NativeType(value="SDL_Colorspace")
    public int colorspace() {
        return SDL_CameraSpec.ncolorspace(this.address());
    }

    public int width() {
        return SDL_CameraSpec.nwidth(this.address());
    }

    public int height() {
        return SDL_CameraSpec.nheight(this.address());
    }

    public int framerate_numerator() {
        return SDL_CameraSpec.nframerate_numerator(this.address());
    }

    public int framerate_denominator() {
        return SDL_CameraSpec.nframerate_denominator(this.address());
    }

    public SDL_CameraSpec format(@NativeType(value="SDL_PixelFormat") int value) {
        SDL_CameraSpec.nformat(this.address(), value);
        return this;
    }

    public SDL_CameraSpec colorspace(@NativeType(value="SDL_Colorspace") int value) {
        SDL_CameraSpec.ncolorspace(this.address(), value);
        return this;
    }

    public SDL_CameraSpec width(int value) {
        SDL_CameraSpec.nwidth(this.address(), value);
        return this;
    }

    public SDL_CameraSpec height(int value) {
        SDL_CameraSpec.nheight(this.address(), value);
        return this;
    }

    public SDL_CameraSpec framerate_numerator(int value) {
        SDL_CameraSpec.nframerate_numerator(this.address(), value);
        return this;
    }

    public SDL_CameraSpec framerate_denominator(int value) {
        SDL_CameraSpec.nframerate_denominator(this.address(), value);
        return this;
    }

    public SDL_CameraSpec set(int format, int colorspace, int width, int height, int framerate_numerator, int framerate_denominator) {
        this.format(format);
        this.colorspace(colorspace);
        this.width(width);
        this.height(height);
        this.framerate_numerator(framerate_numerator);
        this.framerate_denominator(framerate_denominator);
        return this;
    }

    public SDL_CameraSpec set(SDL_CameraSpec src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_CameraSpec malloc() {
        return new SDL_CameraSpec(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_CameraSpec calloc() {
        return new SDL_CameraSpec(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_CameraSpec create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_CameraSpec(MemoryUtil.memAddress(container), container);
    }

    public static SDL_CameraSpec create(long address) {
        return new SDL_CameraSpec(address, null);
    }

    public static @Nullable SDL_CameraSpec createSafe(long address) {
        return address == 0L ? null : new SDL_CameraSpec(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_CameraSpec.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_CameraSpec.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_CameraSpec malloc(MemoryStack stack) {
        return new SDL_CameraSpec(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_CameraSpec calloc(MemoryStack stack) {
        return new SDL_CameraSpec(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int ncolorspace(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORSPACE);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nframerate_numerator(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMERATE_NUMERATOR);
    }

    public static int nframerate_denominator(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMERATE_DENOMINATOR);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void ncolorspace(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORSPACE, value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nframerate_numerator(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMERATE_NUMERATOR, value);
    }

    public static void nframerate_denominator(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMERATE_DENOMINATOR, value);
    }

    static {
        Struct.Layout layout = SDL_CameraSpec.__struct(SDL_CameraSpec.__member(4), SDL_CameraSpec.__member(4), SDL_CameraSpec.__member(4), SDL_CameraSpec.__member(4), SDL_CameraSpec.__member(4), SDL_CameraSpec.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        COLORSPACE = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        FRAMERATE_NUMERATOR = layout.offsetof(4);
        FRAMERATE_DENOMINATOR = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_CameraSpec, Buffer>
    implements NativeResource {
        private static final SDL_CameraSpec ELEMENT_FACTORY = SDL_CameraSpec.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_CameraSpec getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_PixelFormat")
        public int format() {
            return SDL_CameraSpec.nformat(this.address());
        }

        @NativeType(value="SDL_Colorspace")
        public int colorspace() {
            return SDL_CameraSpec.ncolorspace(this.address());
        }

        public int width() {
            return SDL_CameraSpec.nwidth(this.address());
        }

        public int height() {
            return SDL_CameraSpec.nheight(this.address());
        }

        public int framerate_numerator() {
            return SDL_CameraSpec.nframerate_numerator(this.address());
        }

        public int framerate_denominator() {
            return SDL_CameraSpec.nframerate_denominator(this.address());
        }

        public Buffer format(@NativeType(value="SDL_PixelFormat") int value) {
            SDL_CameraSpec.nformat(this.address(), value);
            return this;
        }

        public Buffer colorspace(@NativeType(value="SDL_Colorspace") int value) {
            SDL_CameraSpec.ncolorspace(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            SDL_CameraSpec.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            SDL_CameraSpec.nheight(this.address(), value);
            return this;
        }

        public Buffer framerate_numerator(int value) {
            SDL_CameraSpec.nframerate_numerator(this.address(), value);
            return this;
        }

        public Buffer framerate_denominator(int value) {
            SDL_CameraSpec.nframerate_denominator(this.address(), value);
            return this;
        }
    }
}

