/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_AudioDeviceEvent
extends Struct<SDL_AudioDeviceEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WHICH;
    public static final int RECORDING;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_AudioDeviceEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_AudioDeviceEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_AudioDeviceEvent(address, container);
    }

    public SDL_AudioDeviceEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_AudioDeviceEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_AudioDeviceEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_AudioDeviceEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_AudioDeviceID")
    public int which() {
        return SDL_AudioDeviceEvent.nwhich(this.address());
    }

    @NativeType(value="bool")
    public boolean recording() {
        return SDL_AudioDeviceEvent.nrecording(this.address());
    }

    public SDL_AudioDeviceEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_AudioDeviceEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_AudioDeviceEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_AudioDeviceEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_AudioDeviceEvent which(@NativeType(value="SDL_AudioDeviceID") int value) {
        SDL_AudioDeviceEvent.nwhich(this.address(), value);
        return this;
    }

    public SDL_AudioDeviceEvent recording(@NativeType(value="bool") boolean value) {
        SDL_AudioDeviceEvent.nrecording(this.address(), value);
        return this;
    }

    public SDL_AudioDeviceEvent set(int type, long timestamp, int which, boolean recording) {
        this.type(type);
        this.timestamp(timestamp);
        this.which(which);
        this.recording(recording);
        return this;
    }

    public SDL_AudioDeviceEvent set(SDL_AudioDeviceEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_AudioDeviceEvent malloc() {
        return new SDL_AudioDeviceEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_AudioDeviceEvent calloc() {
        return new SDL_AudioDeviceEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_AudioDeviceEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_AudioDeviceEvent(MemoryUtil.memAddress(container), container);
    }

    public static SDL_AudioDeviceEvent create(long address) {
        return new SDL_AudioDeviceEvent(address, null);
    }

    public static @Nullable SDL_AudioDeviceEvent createSafe(long address) {
        return address == 0L ? null : new SDL_AudioDeviceEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_AudioDeviceEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_AudioDeviceEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_AudioDeviceEvent malloc(MemoryStack stack) {
        return new SDL_AudioDeviceEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_AudioDeviceEvent calloc(MemoryStack stack) {
        return new SDL_AudioDeviceEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMESTAMP);
    }

    public static int nwhich(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WHICH);
    }

    public static boolean nrecording(long struct) {
        return MemoryUtil.memGetByte(struct + (long)RECORDING) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED, value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMESTAMP, value);
    }

    public static void nwhich(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WHICH, value);
    }

    public static void nrecording(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)RECORDING, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    static {
        Struct.Layout layout = SDL_AudioDeviceEvent.__struct(SDL_AudioDeviceEvent.__member(4), SDL_AudioDeviceEvent.__member(4), SDL_AudioDeviceEvent.__member(8), SDL_AudioDeviceEvent.__member(4), SDL_AudioDeviceEvent.__member(1), SDL_AudioDeviceEvent.__member(1), SDL_AudioDeviceEvent.__member(1), SDL_AudioDeviceEvent.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WHICH = layout.offsetof(3);
        RECORDING = layout.offsetof(4);
        PADDING1 = layout.offsetof(5);
        PADDING2 = layout.offsetof(6);
        PADDING3 = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<SDL_AudioDeviceEvent, Buffer>
    implements NativeResource {
        private static final SDL_AudioDeviceEvent ELEMENT_FACTORY = SDL_AudioDeviceEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_AudioDeviceEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_AudioDeviceEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_AudioDeviceEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_AudioDeviceID")
        public int which() {
            return SDL_AudioDeviceEvent.nwhich(this.address());
        }

        @NativeType(value="bool")
        public boolean recording() {
            return SDL_AudioDeviceEvent.nrecording(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_AudioDeviceEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_AudioDeviceEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer which(@NativeType(value="SDL_AudioDeviceID") int value) {
            SDL_AudioDeviceEvent.nwhich(this.address(), value);
            return this;
        }

        public Buffer recording(@NativeType(value="bool") boolean value) {
            SDL_AudioDeviceEvent.nrecording(this.address(), value);
            return this;
        }
    }
}

